/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.client.network.status.IClientStatusNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.status.client.CPingPacket;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SPongPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPinger {
    public static final ServerPinger INSTANCE = new ServerPinger();
    private static final Logger logger = LogManager.getLogger();
    private static final Executor executor = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(logger)).build());
    private final List<NetworkManager> pendingPings = Collections.synchronizedList(Lists.newArrayList());

    private ServerPinger() {
    }

    public void ping(final String hostName, final int port, final Consumer<PingData> callback) {
        executor.execute(() -> {
            NetworkManager networkManagger;
            try {
                networkManagger = NetworkManager.func_181124_a((InetAddress)InetAddress.getByName(hostName), (int)port, (boolean)false);
            }
            catch (Throwable e) {
                callback.accept(PingData.FAILED);
                return;
            }
            this.pendingPings.add(networkManagger);
            networkManagger.func_150719_a((INetHandler)new IClientStatusNetHandler(){
                private boolean successful;
                private boolean receivedStatus;
                private long pingSentAt;
                private PingData pingData = new PingData();

                public void func_147397_a(SServerInfoPacket packet) {
                    if (this.receivedStatus) {
                        networkManagger.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.unrequested"));
                    } else {
                        this.receivedStatus = true;
                        ServerStatusResponse status = packet.func_149294_c();
                        if (status.func_151317_a() != null) {
                            this.pingData.motd = status.func_151317_a();
                        } else {
                            this.pingData.motd = StringTextComponent.field_240750_d_;
                        }
                        this.pingData.setServerVersion((ITextComponent)new StringTextComponent(status.func_151322_c().func_151303_a()));
                        this.pingData.setVersion(status.func_151322_c().func_151304_b());
                        this.pingData.setPlayersAmount((ITextComponent)new StringTextComponent(status.func_151318_b().func_151333_b() + "/" + status.func_151318_b().func_151332_a()));
                        this.pingSentAt = Util.func_211177_b();
                        networkManagger.func_179290_a((IPacket)new CPingPacket(this.pingSentAt));
                        this.successful = true;
                    }
                }

                public void func_147398_a(SPongPacket packetIn) {
                    long i = this.pingSentAt;
                    long j = Util.func_211177_b();
                    this.pingData.setPing(j - i);
                    networkManagger.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.finished"));
                }

                public void func_147231_a(ITextComponent reason) {
                    if (!this.successful) {
                        logger.error("Can't ping {}:{} Reason: {}", (Object)hostName, (Object)port, (Object)reason.getString());
                        this.pingData.setMotd((ITextComponent)new TranslationTextComponent("multiplayer.status.cannot_connect"));
                        this.pingData.setPlayersAmount((ITextComponent)new StringTextComponent("?"));
                    }
                    callback.accept(this.pingData);
                }

                public NetworkManager func_147298_b() {
                    return networkManagger;
                }
            });
            try {
                networkManagger.func_179290_a((IPacket)new CHandshakePacket(hostName, port, ProtocolType.STATUS));
                networkManagger.func_179290_a((IPacket)new CServerQueryPacket());
            }
            catch (Throwable t) {
                callback.accept(PingData.FAILED);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingPendingNetworks() {
        List<NetworkManager> list = this.pendingPings;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.pendingPings.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.func_150724_d()) {
                    networkmanager.func_74428_b();
                    continue;
                }
                iterator.remove();
                networkmanager.func_179293_l();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingNetworks() {
        List<NetworkManager> list = this.pendingPings;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.pendingPings.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (!networkmanager.func_150724_d()) continue;
                iterator.remove();
                networkmanager.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.cancelled"));
            }
        }
    }

    public static class PingData {
        public static final PingData FAILED = new PingData();
        private long ping;
        private ITextComponent motd;
        private ITextComponent serverVersion;
        private ITextComponent playersAmount;
        private int version;

        public long getPing() {
            return this.ping;
        }

        public void setPing(long ping) {
            this.ping = ping;
        }

        public ITextComponent getMotd() {
            return this.motd;
        }

        public void setMotd(ITextComponent motd) {
            this.motd = motd;
        }

        public ITextComponent getPlayersAmount() {
            return this.playersAmount;
        }

        public void setPlayersAmount(ITextComponent playersAmount) {
            this.playersAmount = playersAmount;
        }

        public ITextComponent getServerVersion() {
            return this.serverVersion;
        }

        public void setServerVersion(ITextComponent serverVersion) {
            this.serverVersion = serverVersion;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        static {
            PingData.FAILED.ping = -1L;
            PingData.FAILED.motd = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.RED);
            PingData.FAILED.serverVersion = new TranslationTextComponent("multiplayer.status.old");
            PingData.FAILED.version = 0;
            PingData.FAILED.playersAmount = new StringTextComponent("?");
        }
    }
}

