/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.network.NetworkProtocol;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class GameType
extends ForgeRegistryEntry<GameType> {
    public static final Codec<GameType> CODEC = ResourceLocation.field_240908_a_.flatXmap(registryName -> {
        GameType gameType = (GameType)((IForgeRegistry)GameTypes.REGISTRY.get()).getValue(registryName);
        return gameType == null ? DataResult.error((String)("Unknown registry key: " + registryName.toString())) : DataResult.success((Object)((Object)gameType));
    }, gameType -> DataResult.success((Object)gameType.getRegistryName()));
    private final Codec<? extends GameServer> gameServerCodec;
    private final Supplier<DistExecutor.SafeCallable<GameClient>> gameClientFactory;
    private final NetworkProtocol networkProtocol;

    public GameType(Codec<? extends GameServer> gameServerCodec, Supplier<DistExecutor.SafeCallable<GameClient>> gameClientFactory, NetworkProtocol networkProtocol) {
        this.gameServerCodec = gameServerCodec;
        this.gameClientFactory = gameClientFactory;
        this.networkProtocol = networkProtocol;
    }

    public Codec<? extends GameServer> getGameServerCodec() {
        return this.gameServerCodec;
    }

    public GameClient createGameClient() {
        GameClient gameClient = (GameClient)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, this.gameClientFactory);
        if (gameClient == null) {
            throw new IllegalStateException("Attempting to create game client on a server!");
        }
        return gameClient;
    }

    public NetworkProtocol getNetworkProtocol() {
        return this.networkProtocol;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(Util.func_200697_a((String)"game", (ResourceLocation)this.getRegistryName()));
    }
}

