/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class GameUtil {
    private static final String SQUARE_UTF_8 = "\u2588";
    private static final ITextComponent CHAT_SEPERATOR = new StringTextComponent(StringUtils.repeat((String)"\u2588", (int)30));
    public static final ITextComponent NEW_LINE = new StringTextComponent("\n\n");

    public static ITextComponent formatMessage(ITextComponent message) {
        return new TranslationTextComponent("message.game").func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new StringTextComponent(" >>> ").func_240700_a_(style -> style.func_240713_a_(Boolean.valueOf(true)).func_240718_a_(Color.func_240743_a_((int)0xFFFFFF)))).func_230529_a_((ITextComponent)message.func_230532_e_().func_240699_a_(TextFormatting.GRAY));
    }

    public static void sendGameMessageToAll(ITextComponent message, MinecraftServer minecraftServer) {
        minecraftServer.func_184103_al().func_232641_a_(GameUtil.formatMessage(message), ChatType.SYSTEM, Util.field_240973_b_);
    }

    public static void sendAnnouncement(ITextComponent message, MinecraftServer minecraftServer) {
        minecraftServer.func_184103_al().func_148540_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, message));
    }

    public static void sendChatAnnouncement(ITextComponent title, ITextComponent body, MinecraftServer minecraftServer) {
        IFormattableTextComponent announcement = CHAT_SEPERATOR.func_230532_e_().func_230529_a_(NEW_LINE).func_230529_a_((ITextComponent)title.func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)))).func_230529_a_(NEW_LINE).func_230529_a_(body).func_230529_a_(NEW_LINE).func_230529_a_(CHAT_SEPERATOR);
        minecraftServer.func_184103_al().func_232641_a_((ITextComponent)announcement, ChatType.SYSTEM, Util.field_240973_b_);
    }

    public static void broadcastSound(SoundEvent soundEvent, MinecraftServer minecraftServer) {
        GameUtil.broadcastSound(soundEvent, minecraftServer, 0.7f, 1.0f);
    }

    public static void broadcastSound(SoundEvent soundEvent, MinecraftServer minecraftServer, float volume, float pitch) {
        minecraftServer.func_184103_al().func_181057_v().forEach(playerEntity -> playerEntity.func_213823_a(soundEvent, SoundCategory.MASTER, volume, pitch));
    }
}

