/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.shop.ShopScreen;
import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.shop.ShopModule;
import com.craftingdead.immerse.game.module.shop.message.BuyItemMessage;
import com.craftingdead.immerse.game.module.shop.message.SyncUserMessage;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.game.network.MessageHandlerRegistry;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientShopModule
extends ShopModule
implements Module.Tickable {
    private static final MessageHandlerRegistry<ClientShopModule> messageHandlers = new MessageHandlerRegistry();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int buyTimeSeconds;
    private int money;

    public void buyItem(UUID itemId) {
        GameNetworkChannel.sendToServer(this.getType(), new BuyItemMessage(itemId));
    }

    public int getBuyTimeSeconds() {
        return this.buyTimeSeconds;
    }

    public boolean canAfford(int amount) {
        return this.getMoney() >= amount;
    }

    public int getMoney() {
        return this.money;
    }

    private void handleSyncUser(SyncUserMessage message, NetworkEvent.Context context) {
        this.buyTimeSeconds = message.getBuyTimeSeconds();
        this.money = message.getMoney();
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        messageHandlers.handle(this, message, context);
    }

    @Override
    public void tick() {
        while (this.minecraft.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.minecraft.field_71439_g.func_175149_v()) continue;
            PlayerExtension player = PlayerExtension.getOrThrow((PlayerEntity)this.minecraft.field_71439_g);
            if (this.buyTimeSeconds > 0) {
                this.minecraft.func_147108_a((Screen)new ShopScreen(null, this, player));
                continue;
            }
            this.minecraft.field_71456_v.func_146158_b().func_146227_a(GameUtil.formatMessage((ITextComponent)new TranslationTextComponent("message.buy_time_expired")));
        }
    }

    static {
        messageHandlers.register(SyncUserMessage.class, ClientShopModule::handleSyncUser);
    }
}

