/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.combatslot.CombatSlotType;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.ServerModule;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import com.craftingdead.immerse.game.module.shop.ShopModule;
import com.craftingdead.immerse.game.module.shop.message.BuyItemMessage;
import com.craftingdead.immerse.game.module.shop.message.SyncUserMessage;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.game.network.MessageHandlerRegistry;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.server.permission.PermissionAPI;

public class ServerShopModule
extends ShopModule
implements ServerModule,
Module.Tickable {
    public static final BiConsumer<PlayerExtension<?>, ItemStack> COMBAT_PURCHASE_HANDLER = (player, item) -> ((CombatSlotType)CombatSlotType.getSlotType((ItemStack)item).orElseThrow(() -> new IllegalStateException("Invalid item"))).addToInventory(item, ((PlayerEntity)player.getEntity()).field_71071_by, true);
    private static final MessageHandlerRegistry<ServerShopModule> messageHandlers = new MessageHandlerRegistry();
    private final Map<UUID, ShopUser> users = new HashMap<UUID, ShopUser>();
    private final BiConsumer<PlayerExtension<?>, ItemStack> purchaseHandler;
    private final int defaultBuyTimeSeconds;
    private int secondTimer;

    public ServerShopModule(BiConsumer<PlayerExtension<?>, ItemStack> purchaseHandler, int defaultBuyTimeSeconds) {
        this.purchaseHandler = purchaseHandler;
        this.defaultBuyTimeSeconds = defaultBuyTimeSeconds;
    }

    public void buyItem(PlayerExtension<ServerPlayerEntity> player, UUID itemId) {
        ShopItem item = (ShopItem)this.items.get(itemId);
        if (item == null) {
            throw new IllegalArgumentException("Unknown item ID: " + itemId.toString());
        }
        ShopUser user = this.users.get(((ServerPlayerEntity)player.getEntity()).func_110124_au());
        if (user.money >= item.getPrice() && user.buyTimeSeconds != 0) {
            ShopUser shopUser = user;
            shopUser.money = shopUser.money - item.getPrice();
            user.sync();
            this.purchaseHandler.accept(player, item.getItemStack());
        }
    }

    public void resetBuyTime(UUID playerId) {
        ShopUser user = this.users.get(playerId);
        if (user != null) {
            user.buyTimeSeconds = this.defaultBuyTimeSeconds;
            user.sync();
        }
    }

    private void handleBuyItem(BuyItemMessage message, NetworkEvent.Context context) {
        this.buyItem((PlayerExtension<ServerPlayerEntity>)PlayerExtension.getOrThrow((PlayerEntity)context.getSender()), message.getItemId());
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        messageHandlers.handle(this, message, context);
    }

    @Override
    public void tick() {
        if (this.secondTimer++ >= 20) {
            this.secondTimer = 0;
            for (ShopUser user : this.users.values()) {
                if (user.buyTimeSeconds <= 0 || !PermissionAPI.hasPermission((GameProfile)user.gameProfile, (String)"craftingdeadimmerse.game.op", null)) continue;
                user.buyTimeSeconds--;
                user.sync();
            }
        }
    }

    @Override
    public void addPlayer(PlayerExtension<ServerPlayerEntity> player) {
        ShopUser user = new ShopUser(((ServerPlayerEntity)player.getEntity()).func_146103_bH(), ((ServerPlayerEntity)player.getEntity()).field_71135_a.field_147371_a);
        this.users.put(((ServerPlayerEntity)player.getEntity()).func_110124_au(), user);
        user.sync();
    }

    @Override
    public void removePlayer(PlayerExtension<ServerPlayerEntity> player) {
        this.users.remove(((ServerPlayerEntity)player.getEntity()).func_110124_au());
    }

    static {
        messageHandlers.register(BuyItemMessage.class, ServerShopModule::handleBuyItem);
    }

    private class ShopUser {
        private final GameProfile gameProfile;
        private final NetworkManager connection;
        private int buyTimeSeconds;
        private int money;

        private ShopUser(GameProfile gameProfile, NetworkManager connection) {
            this.buyTimeSeconds = ServerShopModule.this.defaultBuyTimeSeconds;
            this.gameProfile = gameProfile;
            this.connection = connection;
        }

        private void sync() {
            this.connection.func_179290_a(GameNetworkChannel.toVanillaPacket(ServerShopModule.this.getType(), new SyncUserMessage(this.buyTimeSeconds, this.money), NetworkDirection.PLAY_TO_CLIENT));
        }
    }
}

