/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.network.Synched;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.ModuleType;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.module.shop.ShopCategory;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

class ShopModule
implements Module,
Synched {
    protected final Map<UUID, ShopItem> items = new HashMap<UUID, ShopItem>();
    private final List<ShopCategory> categories = new ArrayList<ShopCategory>();

    ShopModule() {
    }

    public List<ShopCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void addCategory(ShopCategory category) {
        for (ShopItem item : category.getItems()) {
            this.items.put(item.getId(), item);
        }
        this.categories.add(category);
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        if (writeAll) {
            out.func_150787_b(this.items.size());
            for (ShopItem item : this.items.values()) {
                out.func_179252_a(item.getId());
                out.writeItemStack(item.getItemStack(), true);
                out.func_150787_b(item.getPrice());
            }
        } else {
            out.func_150787_b(-1);
        }
        if (writeAll) {
            out.func_150787_b(this.categories.size());
            for (ShopCategory category : this.categories) {
                out.func_179256_a(category.getDisplayName());
                out.func_179256_a(category.getInfo());
                out.func_150787_b(category.getItems().size());
                for (ShopItem item : category.getItems()) {
                    out.func_179252_a(item.getId());
                }
            }
        } else {
            out.func_150787_b(-1);
        }
    }

    public void decode(PacketBuffer in) {
        int categoriesSize;
        int itemsSize = in.func_150792_a();
        if (itemsSize > 0) {
            this.items.clear();
            for (int i = 0; i < itemsSize; ++i) {
                ShopItem item = new ShopItem(in.func_179253_g(), in.func_150791_c(), in.func_150792_a());
                this.items.put(item.getId(), item);
            }
        }
        if ((categoriesSize = in.func_150792_a()) > 0) {
            this.categories.clear();
            for (int i = 0; i < categoriesSize; ++i) {
                ITextComponent displayName = in.func_179258_d();
                ITextComponent info = in.func_179258_d();
                ArrayList<ShopItem> items = new ArrayList<ShopItem>();
                int categoryItemsSize = in.func_150792_a();
                for (int j = 0; j < categoryItemsSize; ++j) {
                    UUID itemId = in.func_179253_g();
                    ShopItem item = this.items.get(itemId);
                    if (item == null) {
                        throw new IllegalStateException("Unknown item with ID: " + itemId.toString());
                    }
                    items.add(item);
                }
                this.categories.add(new ShopCategory(displayName, info, items));
            }
        }
    }

    public boolean requiresSync() {
        return false;
    }

    @Override
    public ModuleType getType() {
        return (ModuleType)ModuleTypes.SHOP.get();
    }
}

