/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.team;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.INBTSerializable;

public class TeamInstance<T extends Team>
implements INBTSerializable<CompoundNBT>,
Synched {
    protected final SynchedData dataManager = new SynchedData();
    private final T team;
    private final List<UUID> members = new ArrayList<UUID>();

    public TeamInstance(T team) {
        this.team = team;
        this.team.registerDataParameters(this.dataManager);
    }

    public void broadcastVictorySounds(SoundEvent teamVictoryCallout, MinecraftServer minecraftServer) {
        this.forEach(playerEntity -> {
            playerEntity.func_213823_a((SoundEvent)ImmerseSoundEvents.VICTORY_MUSIC.get(), SoundCategory.MASTER, 0.7f, 1.0f);
            playerEntity.func_213823_a(teamVictoryCallout, SoundCategory.MASTER, 0.7f, 1.0f);
        }, minecraftServer);
    }

    public void broadcastDefeatSounds(SoundEvent teamDefeatCallout, MinecraftServer minecraftServer) {
        this.forEach(playerEntity -> {
            playerEntity.func_213823_a((SoundEvent)ImmerseSoundEvents.DEFEAT_MUSIC.get(), SoundCategory.MASTER, 0.7f, 1.0f);
            playerEntity.func_213823_a(teamDefeatCallout, SoundCategory.MASTER, 0.7f, 1.0f);
        }, minecraftServer);
    }

    public void forEach(Consumer<ServerPlayerEntity> action, MinecraftServer minecraftServer) {
        for (UUID memberId : this.members) {
            action.accept(minecraftServer.func_184103_al().func_177451_a(memberId));
        }
    }

    void addMember(UUID memberId) {
        this.members.add(memberId);
    }

    void removeMember(UUID memberId) {
        this.members.remove(memberId);
    }

    public SynchedData getDataManager() {
        return this.dataManager;
    }

    public List<UUID> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public T getTeam() {
        return this.team;
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (PacketBuffer)out);
    }

    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack((PacketBuffer)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.team.save(this, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.team.load(this, nbt);
    }
}

