/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.team;

import com.craftingdead.core.network.Synched;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.ModuleType;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class TeamModule<T extends Enum<T>>
implements Module,
Synched {
    private final Class<T> teamType;
    private final Map<T, TeamInstance<T>> teams;
    protected final Map<UUID, T> playerTeams = new HashMap<UUID, T>();
    protected final Map<UUID, T> dirtyPlayerTeams = new HashMap<UUID, T>();

    public TeamModule(Class<T> teamType) {
        this.teamType = teamType;
        this.teams = new EnumMap<T, TeamInstance<T>>(teamType);
    }

    public void registerTeam(T team) {
        this.teams.put(team, new TeamInstance<Team>((Team)team));
    }

    public TeamInstance<T> getSmallestTeam() {
        TeamInstance<T> smallestTeam = null;
        for (TeamInstance<T> team : this.teams.values()) {
            if (smallestTeam != null && team.getMembers().size() >= smallestTeam.getMembers().size()) continue;
            smallestTeam = team;
        }
        return smallestTeam;
    }

    public TeamInstance<T> getTeamInstance(T team) {
        return this.teams.get(team);
    }

    public Optional<T> getPlayerTeam(UUID playerId) {
        return Optional.ofNullable(this.playerTeams.get(playerId));
    }

    @Override
    public ModuleType getType() {
        return (ModuleType)ModuleTypes.TEAM.get();
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        for (Map.Entry<T, TeamInstance<T>> entry : this.teams.entrySet()) {
            if (!entry.getValue().requiresSync()) continue;
            out.func_150787_b(((Enum)entry.getKey()).ordinal());
            entry.getValue().encode(out, false);
        }
        out.func_150787_b(-1);
        boolean writePlayerTeams = writeAll || !this.dirtyPlayerTeams.isEmpty();
        out.writeBoolean(writePlayerTeams);
        if (writePlayerTeams) {
            out.writeBoolean(writeAll);
            Map<UUID, T> playerTeamsToSend = writeAll ? this.playerTeams : this.dirtyPlayerTeams;
            out.func_150787_b(playerTeamsToSend.size());
            for (Map.Entry<UUID, T> entry : playerTeamsToSend.entrySet()) {
                out.func_179252_a(entry.getKey());
                if (entry.getValue() == null) {
                    out.writeBoolean(true);
                    continue;
                }
                out.writeBoolean(false);
                out.func_179249_a((Enum)entry.getValue());
            }
        }
        if (!writeAll) {
            this.dirtyPlayerTeams.clear();
        }
    }

    private TeamInstance<T> getExpectedTeamInstance(T team) {
        TeamInstance<T> teamInstance = this.teams.get(team);
        if (teamInstance == null) {
            throw new IllegalStateException("Expected team '" + ((Enum)team).toString() + "' to be present");
        }
        return teamInstance;
    }

    public void decode(PacketBuffer in) {
        int i;
        while ((i = in.func_150792_a()) != -1) {
            Enum team = ((Enum[])this.teamType.getEnumConstants())[i];
            this.getExpectedTeamInstance(team).decode(in);
        }
        if (in.readBoolean()) {
            if (in.readBoolean()) {
                this.playerTeams.clear();
            }
            int playerTeamsSize = in.func_150792_a();
            for (int j = 0; j < playerTeamsSize; ++j) {
                Enum team;
                UUID playerId = in.func_179253_g();
                if (in.readBoolean()) {
                    TeamInstance<Enum> teamInstance;
                    team = (Enum)this.playerTeams.remove(playerId);
                    if (team == null || (teamInstance = this.getTeamInstance(team)) == null) continue;
                    teamInstance.removeMember(playerId);
                    continue;
                }
                team = in.func_179257_a(this.teamType);
                Enum oldTeam = this.playerTeams.put(playerId, team);
                if (oldTeam != null) {
                    this.getExpectedTeamInstance(oldTeam).removeMember(playerId);
                }
                this.getExpectedTeamInstance(team).addMember(playerId);
            }
        }
    }

    public boolean requiresSync() {
        return this.teams.values().stream().anyMatch(TeamInstance::requiresSync) || !this.dirtyPlayerTeams.isEmpty();
    }
}

