/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHandlerRegistry<T> {
    private final Map<Class<?>, MessageHandler<T, ?>> handlers = new Object2ObjectOpenHashMap();

    public <MSG> void register(Class<MSG> type, MessageHandler<T, MSG> handler) {
        this.handlers.put(type, handler);
    }

    public <MSG> void handle(T parent, MSG message, NetworkEvent.Context context) {
        MessageHandler<T, ?> handler = this.handlers.get(message.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("No handler for message type: " + message.getClass().getName());
        }
        handler.handle(parent, message, context);
    }

    public static interface MessageHandler<T, MSG> {
        public void handle(T var1, MSG var2, NetworkEvent.Context var3);
    }
}

