/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.network;

import com.craftingdead.immerse.game.network.NetworkProtocol;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SimpleNetworkProtocol
implements NetworkProtocol {
    private final Map<Byte, Codec<?>> codecIndicies = new Byte2ObjectArrayMap();
    private final Map<Class<?>, Codec<?>> codecTypes = new Object2ObjectArrayMap();

    public <T> CodecBuilder<T> codecBuilder(int index, Class<T> type) {
        return new CodecBuilder(index, type);
    }

    @Override
    public <T> void encode(PacketBuffer buf, T payload) throws IOException {
        Codec<?> entry = this.codecTypes.get(payload.getClass());
        if (entry == null) {
            throw new IOException("Unknown payload type " + payload.getClass().getName());
        }
        buf.writeByte((int)((Codec)entry).index);
        ((Codec)entry).encoder.accept(payload, buf);
    }

    @Override
    public <T> T decode(PacketBuffer buf, NetworkEvent.Context ctx) throws IOException {
        byte index = buf.readByte();
        Codec<?> entry = this.codecIndicies.get(index);
        if (entry != null) {
            return (T)((Codec)entry).decoder.apply(buf);
        }
        throw new IOException("Unknown payload index " + index);
    }

    public class CodecBuilder<T> {
        private final byte index;
        private final Class<T> type;
        private BiConsumer<T, PacketBuffer> encoder;
        private Function<PacketBuffer, T> decoder;

        private CodecBuilder(int index, Class<T> type) {
            if (index >= 256) {
                throw new IllegalArgumentException("Index larger than unsigned byte, must be below 256");
            }
            this.index = (byte)(index & 0xFF);
            this.type = type;
        }

        public CodecBuilder<T> emptyEncoder() {
            return this.encoder((x, y) -> {});
        }

        public CodecBuilder<T> encoder(BiConsumer<T, PacketBuffer> encoder) {
            this.encoder = encoder;
            return this;
        }

        public CodecBuilder<T> unitDecoder(Supplier<T> value) {
            return this.decoder(in -> value.get());
        }

        public CodecBuilder<T> decoder(Function<PacketBuffer, T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public SimpleNetworkProtocol register() {
            Codec entry = new Codec(this.index, this.encoder, this.decoder);
            if (SimpleNetworkProtocol.this.codecIndicies.containsKey(this.index)) {
                throw new IllegalArgumentException("Codec with index " + this.index + " already registered");
            }
            SimpleNetworkProtocol.this.codecIndicies.put(this.index, entry);
            if (SimpleNetworkProtocol.this.codecTypes.containsKey(this.type)) {
                throw new IllegalArgumentException("Codec with type " + this.type.getName() + " already registered");
            }
            SimpleNetworkProtocol.this.codecTypes.put(this.type, entry);
            return SimpleNetworkProtocol.this;
        }
    }

    private static class Codec<T> {
        private final byte index;
        private final BiConsumer<T, PacketBuffer> encoder;
        private final Function<PacketBuffer, T> decoder;

        private Codec(byte index, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder) {
            this.index = index;
            this.encoder = encoder;
            this.decoder = decoder;
        }
    }
}

