/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class SurvivalGame<M extends Module>
implements Game<M> {
    @Override
    public boolean disableBlockBurning() {
        return true;
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void unload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void tick() {
    }

    @SubscribeEvent
    public void handleLivingExtensionLoad(LivingExtensionEvent.Load event) {
        if (event.getLiving() instanceof PlayerExtension && !event.getLiving().getHandler(SurvivalPlayerHandler.EXTENSION_ID).isPresent()) {
            PlayerExtension player = (PlayerExtension)event.getLiving();
            player.registerHandler(SurvivalPlayerHandler.EXTENSION_ID, (LivingHandler)new SurvivalPlayerHandler(player));
        }
    }

    @Override
    public GameType getType() {
        return (GameType)GameTypes.SURVIVAL.get();
    }

    public void encode(PacketBuffer out, boolean writeAll) {
    }

    public void decode(PacketBuffer in) {
    }

    public boolean requiresSync() {
        return false;
    }
}

