/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.immerse.game.GameTypes;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;

public class SurvivalPlayerHandler
implements PlayerHandler {
    public static final ResourceLocation EXTENSION_ID = GameTypes.SURVIVAL.getId();
    private static final DataParameter<Integer> DAYS_SURVIVED = new DataParameter(0, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ZOMBIES_KILLED = new DataParameter(1, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLAYERS_KILLED = new DataParameter(2, DataSerializers.field_187192_b);
    private final PlayerExtension<?> player;
    private final SynchedData dataManager = new SynchedData();

    public SurvivalPlayerHandler(PlayerExtension<?> player) {
        this.player = player;
        this.dataManager.register(DAYS_SURVIVED, (Object)0);
        this.dataManager.register(ZOMBIES_KILLED, (Object)0);
        this.dataManager.register(PLAYERS_KILLED, (Object)0);
    }

    public void tick() {
        if (this.player.getEntity() instanceof ServerPlayerEntity) {
            int aliveTicks = ((ServerPlayerEntity)this.player.getEntity()).func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
            this.setDaysSurvived(aliveTicks / 20 / 60 / 20);
        }
    }

    public boolean handleKill(Entity target) {
        if (target instanceof ZombieEntity) {
            this.setZombiesKilled(this.getZombiesKilled() + 1);
        } else if (target instanceof ServerPlayerEntity) {
            this.setPlayersKilled(this.getPlayersKilled() + 1);
        }
        return false;
    }

    public int getDaysSurvived() {
        return (Integer)this.dataManager.get(DAYS_SURVIVED);
    }

    public void setDaysSurvived(int daysSurvived) {
        this.dataManager.set(DAYS_SURVIVED, (Object)daysSurvived);
    }

    public int getZombiesKilled() {
        return (Integer)this.dataManager.get(ZOMBIES_KILLED);
    }

    public void setZombiesKilled(int zombiesKilled) {
        this.dataManager.set(ZOMBIES_KILLED, (Object)zombiesKilled);
    }

    public int getPlayersKilled() {
        return (Integer)this.dataManager.get(PLAYERS_KILLED);
    }

    public void setPlayersKilled(int playersKilled) {
        this.dataManager.set(PLAYERS_KILLED, (Object)playersKilled);
    }

    public boolean isCombatModeEnabled() {
        return false;
    }

    public void copyFrom(PlayerExtension<?> that, boolean wasDeath) {
        if (!wasDeath) {
            that.getHandler(GameTypes.SURVIVAL.getId()).map(extension -> (SurvivalPlayerHandler)extension).ifPresent(extension -> {
                this.setDaysSurvived(extension.getDaysSurvived());
                this.setZombiesKilled(extension.getZombiesKilled());
                this.setPlayersKilled(extension.getPlayersKilled());
            });
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("zombiesKilled", this.getZombiesKilled());
        nbt.func_74768_a("playersKilled", this.getPlayersKilled());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setZombiesKilled(nbt.func_74762_e("zombiesKilled"));
        this.setPlayersKilled(nbt.func_74762_e("playersKilled"));
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (PacketBuffer)out);
    }

    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack((PacketBuffer)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

