/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.SelectTeamScreen;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.shop.ClientShopModule;
import com.craftingdead.immerse.game.module.team.ClientTeamModule;
import com.craftingdead.immerse.game.module.team.TeamModule;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TdmClient
extends TdmGame<Module>
implements GameClient {
    private static final ResourceLocation STOPWATCH = new ResourceLocation("craftingdeadimmerse", "textures/gui/stopwatch.png");
    private static final ResourceLocation BANNER_INVERTED = new ResourceLocation("craftingdeadimmerse", "textures/gui/banner_inverted.png");
    private static final ResourceLocation DEAD = new ResourceLocation("craftingdeadimmerse", "textures/gui/dead.png");
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private ClientShopModule shopModule;
    private ClientTeamModule<TdmTeam> teamModule;
    private TdmState lastGameState;
    private boolean sentInitialTeamRequest = false;

    public TdmClient() {
        super("");
    }

    private ITextComponent getTimer() {
        TextFormatting colour;
        int totalSeconds = this.getTimerValueSeconds();
        int mins = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        switch (this.getGameState()) {
            case PRE_GAME: {
                colour = TextFormatting.YELLOW;
                break;
            }
            case GAME: {
                if (totalSeconds <= 20) {
                    colour = TextFormatting.RED;
                    break;
                }
            }
            default: {
                colour = TextFormatting.WHITE;
            }
        }
        return new StringTextComponent(mins + ":" + (seconds < 10 ? "0" : "") + seconds).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, colour});
    }

    @Override
    public TeamModule<TdmTeam> getTeamModule() {
        return this.teamModule;
    }

    @Override
    public void registerModules(Consumer<Module> registrar) {
        this.shopModule = new ClientShopModule();
        registrar.accept(this.shopModule);
        this.teamModule = new ClientTeamModule<TdmTeam>(TdmTeam.class, SelectTeamScreen::new);
        registrar.accept(this.teamModule);
        super.registerModules(registrar);
    }

    @Override
    public boolean disableSwapHands() {
        return true;
    }

    @Override
    public void tick() {
        if (this.getGameState() != this.lastGameState && this.minecraft.field_71439_g != null && this.getTeamModule().getPlayerTeam(this.minecraft.field_71439_g.func_110124_au()).isPresent()) {
            this.lastGameState = this.getGameState();
            switch (this.getGameState()) {
                case PRE_GAME: {
                    this.minecraft.field_71456_v.func_175177_a();
                    this.minecraft.field_71456_v.func_238452_a_((ITextComponent)new TranslationTextComponent("title.warm_up").func_240699_a_(TextFormatting.YELLOW), null, -1, -1, -1);
                    break;
                }
                case GAME: {
                    this.minecraft.field_71456_v.func_175177_a();
                    this.minecraft.field_71456_v.func_238452_a_((ITextComponent)new TranslationTextComponent("title.game_start").func_240699_a_(TextFormatting.AQUA), null, -1, -1, -1);
                    break;
                }
                case POST_GAME: {
                    this.minecraft.field_71456_v.func_175177_a();
                    this.minecraft.field_71456_v.func_238452_a_((ITextComponent)new TranslationTextComponent("title.game_over").func_240699_a_(TextFormatting.RED), null, -1, -1, -1);
                    break;
                }
            }
        }
        if (!this.sentInitialTeamRequest && this.minecraft.field_71441_e != null) {
            this.minecraft.func_147108_a((Screen)new SelectTeamScreen());
            this.sentInitialTeamRequest = true;
        }
    }

    @Override
    public boolean renderOverlay(PlayerExtension<? extends AbstractClientPlayerEntity> player, MatrixStack matrixStack, int width, int height, float partialTicks) {
        int middleWidth = width / 2;
        IFormattableTextComponent redScore = new StringTextComponent(String.valueOf(TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.RED)))).func_240703_c_(TdmTeam.RED.getColourStyle());
        IFormattableTextComponent blueScore = new StringTextComponent(String.valueOf(TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.BLUE)))).func_240703_c_(TdmTeam.BLUE.getColourStyle());
        ITextComponent timer = this.getTimer();
        RenderUtil.fillWidthHeight(matrixStack, middleWidth - 19, 15.0, 18.0, 11.0, -1728053248);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (ITextComponent)redScore, (int)(middleWidth - 9), (int)17, (int)0);
        RenderUtil.fillWidthHeight(matrixStack, middleWidth + 1, 15.0, 18.0, 11.0, -1728053248);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (ITextComponent)blueScore, (int)(middleWidth + 10), (int)17, (int)0);
        RenderUtil.fillWidthHeight(matrixStack, middleWidth - 19, 1.0, 38.0, 13.0, -1728053248);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (ITextComponent)timer, (int)(middleWidth + 1), (int)4, (int)0);
        int headWidth = 20;
        int headHeight = 20;
        List<UUID> redMembers = this.getTeamModule().getTeamInstance(TdmTeam.RED).getMembers();
        for (int i = 0; i < redMembers.size(); ++i) {
            NetworkPlayerInfo playerInfo = this.minecraft.func_147114_u().func_175102_a(redMembers.get(i));
            if (playerInfo == null) continue;
            TdmPlayerData playerData = this.getPlayerData(playerInfo.func_178845_a().getId());
            int x = middleWidth - 21 - 20 - i * 23;
            int y = 2;
            RenderUtil.fillWidthHeight(matrixStack, x - 1, y - 1, 22.0, 22.0, Integer.MIN_VALUE);
            if (playerData.isDead()) {
                RenderUtil.fillWidthHeight(matrixStack, x, y, 20.0, 20.0, Integer.MIN_VALUE);
                RenderSystem.enableBlend();
                RenderUtil.bind(DEAD);
                RenderUtil.blit(matrixStack, x, y, 20.0f, 20.0f);
                RenderSystem.disableBlend();
            } else {
                RenderUtil.renderHead(playerInfo.func_178837_g(), matrixStack, x, y, 20, 20);
            }
            double d = x - 1;
            double d2 = y + 20 + 2;
            this.minecraft.field_71466_p.getClass();
            RenderUtil.fillWidthHeight(matrixStack, d, d2, 22.0, 9 + 2, Integer.MIN_VALUE);
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (String)String.valueOf(playerData.getScore()), (int)(x + 10), (int)(y + 20 + 4), (int)-1);
        }
        List<UUID> blueMembers = this.getTeamModule().getTeamInstance(TdmTeam.BLUE).getMembers();
        for (int i = 0; i < blueMembers.size(); ++i) {
            NetworkPlayerInfo playerInfo = this.minecraft.func_147114_u().func_175102_a(blueMembers.get(i));
            if (playerInfo == null) continue;
            TdmPlayerData playerData = this.getPlayerData(playerInfo.func_178845_a().getId());
            int x = middleWidth + 21 + i * 23;
            int y = 2;
            RenderUtil.fillWidthHeight(matrixStack, x - 1, y - 1, 22.0, 22.0, Integer.MIN_VALUE);
            if (playerData.isDead()) {
                RenderUtil.fillWidthHeight(matrixStack, x, y, 20.0, 20.0, Integer.MIN_VALUE);
                RenderSystem.enableBlend();
                RenderUtil.bind(DEAD);
                RenderUtil.blit(matrixStack, x, y, 20.0f, 20.0f);
                RenderSystem.disableBlend();
            } else {
                RenderUtil.renderHead(playerInfo.func_178837_g(), matrixStack, x, y, 20, 20);
            }
            double d = x - 1;
            double d3 = y + 20 + 2;
            this.minecraft.field_71466_p.getClass();
            RenderUtil.fillWidthHeight(matrixStack, d, d3, 22.0, 9 + 2, Integer.MIN_VALUE);
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (String)String.valueOf(playerData.getScore()), (int)(x + 10), (int)(y + 20 + 4), (int)-1);
        }
        return false;
    }

    @Override
    public boolean renderPlayerList(PlayerExtension<? extends AbstractClientPlayerEntity> player, MatrixStack matrixStack, int width, int height, float partialTicks) {
        int mwidth = width / 2;
        int mheight = height / 2;
        int sbwidth = 330;
        int sbheight = 200;
        int sbx = mwidth - sbwidth / 2;
        int sby = mheight - sbheight / 2 - 18;
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby, sbwidth, 40.0, -872415232);
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby + 3, sbwidth, 34.0, 0x33FFFFFF);
        RenderSystem.enableBlend();
        RenderUtil.bind(BANNER_INVERTED);
        RenderUtil.blit(matrixStack, sbx + 2, sby + 5, 125.0f, 27.5f);
        RenderSystem.disableBlend();
        IFormattableTextComponent gameTitle = this.getType().getDisplayName().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.BOLD});
        this.minecraft.field_71466_p.func_243246_a(matrixStack, (ITextComponent)gameTitle, (float)(sbx + sbwidth - 3 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)gameTitle)), (float)(sby + 9), 0);
        IFormattableTextComponent mapTitle = new StringTextComponent(this.getDisplayName()).func_240699_a_(TextFormatting.GRAY);
        this.minecraft.field_71466_p.func_243246_a(matrixStack, (ITextComponent)mapTitle, (float)(sbx + sbwidth - 3 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)mapTitle)), (float)(sby + 20), 0);
        RenderSystem.enableBlend();
        RenderUtil.bind(STOPWATCH);
        RenderUtil.blit(matrixStack, sbx + sbwidth / 2 - 8, sby + 5, 16.0f, 16.0f);
        RenderSystem.disableBlend();
        ITextComponent timer = this.getTimer();
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (ITextComponent)timer, (int)(sbx + sbwidth / 2), (int)(sby + 24), (int)0);
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby + 41, sbwidth, 193.0, Integer.MIN_VALUE);
        RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 41, sbwidth, 13, (ITextComponent)new StringTextComponent("Ping"), (ITextComponent)new StringTextComponent("Username"), new ITextComponent[]{new StringTextComponent("K"), new StringTextComponent("A"), new StringTextComponent("D"), new StringTextComponent("Score")});
        List<UUID> blueMembers = this.getTeamModule().getTeamInstance(TdmTeam.BLUE).getMembers();
        for (int i = 0; i < blueMembers.size(); ++i) {
            NetworkPlayerInfo playerInfo = this.minecraft.func_147114_u().func_175102_a(blueMembers.get(i));
            if (playerInfo == null) continue;
            StringTextComponent username = playerInfo.func_178854_k() == null ? new StringTextComponent(playerInfo.func_178845_a().getName()) : playerInfo.func_178854_k();
            TdmPlayerData playerData = this.getPlayerData(playerInfo.func_178845_a().getId());
            RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 55 + i * 11, sbwidth, 10, (ITextComponent)new StringTextComponent(String.valueOf(playerInfo.func_178853_c())), (ITextComponent)username, new ITextComponent[]{new StringTextComponent(String.valueOf(playerData.getKills())), new StringTextComponent(String.valueOf(playerData.getAssists())), new StringTextComponent(String.valueOf(playerData.getDeaths())), new StringTextComponent(String.valueOf(playerData.getScore()))});
        }
        List<UUID> redMembers = this.getTeamModule().getTeamInstance(TdmTeam.RED).getMembers();
        for (int i = 0; i < redMembers.size(); ++i) {
            NetworkPlayerInfo playerInfo = this.minecraft.func_147114_u().func_175102_a(redMembers.get(i));
            if (playerInfo == null) continue;
            StringTextComponent username = playerInfo.func_178854_k() == null ? new StringTextComponent(playerInfo.func_178845_a().getName()) : playerInfo.func_178854_k();
            TdmPlayerData playerData = this.getPlayerData(playerInfo.func_178845_a().getId());
            RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 147 + i * 11, sbwidth, 10, (ITextComponent)new StringTextComponent(String.valueOf(playerInfo.func_178853_c())), (ITextComponent)username, new ITextComponent[]{new StringTextComponent(String.valueOf(playerData.getKills())), new StringTextComponent(String.valueOf(playerData.getAssists())), new StringTextComponent(String.valueOf(playerData.getDeaths())), new StringTextComponent(String.valueOf(playerData.getScore()))});
        }
        RenderUtil.fillWidthHeight(matrixStack, sbx + 4, sby + 144, sbwidth - 8, 1.0, -2130706433);
        return true;
    }

    @SubscribeEvent
    public void handleLivingLoad(LivingExtensionEvent.Load event) {
        if (event.getLiving() instanceof PlayerExtension && event.getLiving().getLevel().func_201670_d()) {
            PlayerExtension player = (PlayerExtension)event.getLiving();
            player.registerHandler(TdmPlayerHandler.ID, (LivingHandler)new TdmPlayerHandler(this, player));
        }
    }

    @SubscribeEvent
    public void handleRenderNameplate(RenderNameplateEvent event) {
        TdmTeam ourTeam;
        TdmTeam playerTeam;
        if (event.getEntity() instanceof PlayerEntity && this.minecraft.field_71439_g instanceof PlayerEntity && (playerTeam = (TdmTeam)this.getTeamModule().getPlayerTeam(event.getEntity().func_110124_au()).orElse(null)) != (ourTeam = (TdmTeam)this.getTeamModule().getPlayerTeam(this.minecraft.func_175606_aa().func_110124_au()).orElse(null))) {
            event.setResult(Event.Result.DENY);
        }
    }
}

