/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.CombatPickupEvent;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.OpenEquipmentMenuEvent;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.Attachments;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.module.Module;
import com.craftingdead.immerse.game.module.team.TeamModule;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class TdmGame<M extends Module>
implements Game<M> {
    private static final DataParameter<Boolean> MOVEMENT_BLOCKED = new DataParameter(0, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIMER_VALUE_SECONDS = new DataParameter(1, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GAME_STATE_ORDINAL = new DataParameter(2, DataSerializers.field_187192_b);
    private static final DataParameter<String> DISPLAY_NAME = new DataParameter(3, DataSerializers.field_187194_d);
    private final SynchedData dataManager = new SynchedData();
    private final Map<UUID, TdmPlayerData> playerData = new Object2ObjectOpenHashMap();
    private final Map<UUID, TdmPlayerData> dirtyPlayerData = new Object2ObjectOpenHashMap();

    public TdmGame(String displayName) {
        this.dataManager.register(MOVEMENT_BLOCKED, (Object)false);
        this.dataManager.register(TIMER_VALUE_SECONDS, (Object)0);
        this.dataManager.register(GAME_STATE_ORDINAL, (Object)0);
        this.dataManager.register(DISPLAY_NAME, (Object)displayName);
    }

    public abstract TeamModule<TdmTeam> getTeamModule();

    @Override
    public void registerModules(Consumer<M> registrar) {
        this.getTeamModule().registerTeam(TdmTeam.RED);
        this.getTeamModule().registerTeam(TdmTeam.BLUE);
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void unload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public boolean disableBlockBurning() {
        return true;
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (PacketBuffer)out);
        Set<Map.Entry<UUID, TdmPlayerData>> playerDataCollection = writeAll ? this.playerData.entrySet() : this.dirtyPlayerData.entrySet();
        out.func_150787_b(playerDataCollection.size());
        for (Map.Entry<UUID, TdmPlayerData> entry : playerDataCollection) {
            out.func_179252_a(entry.getKey());
            TdmPlayerData playerData = entry.getValue();
            if (playerData == null) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            playerData.encode(out, writeAll);
        }
        if (!writeAll) {
            this.dirtyPlayerData.clear();
        }
    }

    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack((PacketBuffer)in));
        int playerDataSize = in.func_150792_a();
        for (int i = 0; i < playerDataSize; ++i) {
            UUID playerId = in.func_179253_g();
            if (in.readBoolean()) {
                this.playerData.remove(playerId);
                continue;
            }
            this.getPlayerData(playerId).decode(in);
        }
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty() || !this.dirtyPlayerData.isEmpty();
    }

    @SubscribeEvent
    public void handleCombatPickup(CombatPickupEvent event) {
        if (event.getCombatSlotType() == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleGunInitialize(GunEvent.Initialize event) {
        RefillableAmmoProvider ammoProvider = new RefillableAmmoProvider(event.getGun().getDefaultMagazineStack(), 3, true);
        event.setAmmoProvider((AmmoProvider)ammoProvider);
        Item item = event.getItemStack().func_77973_b();
        if (item == ModItems.AWP.get() || item == ModItems.M107.get() || item == ModItems.AS50.get()) {
            event.addAttachment((Attachment)Attachments.LP_SCOPE.get());
        }
    }

    @SubscribeEvent
    public void handleOpenEquipmentMenu(OpenEquipmentMenuEvent event) {
        event.setCanceled(true);
    }

    public Optional<TdmTeam> getWinningTeam() {
        int blueScore;
        int redScore = TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.RED));
        if (redScore == (blueScore = TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.BLUE)))) {
            return Optional.empty();
        }
        return Optional.of(redScore > blueScore ? TdmTeam.RED : TdmTeam.BLUE);
    }

    public boolean isMovementBlocked() {
        return (Boolean)this.dataManager.get(MOVEMENT_BLOCKED);
    }

    public void setMovementBlocked(boolean movementBlocked) {
        this.dataManager.set(MOVEMENT_BLOCKED, (Object)movementBlocked);
    }

    public int getTimerValueSeconds() {
        return (Integer)this.dataManager.get(TIMER_VALUE_SECONDS);
    }

    public void setTimerValueSeconds(int timerValueSeconds) {
        this.dataManager.set(TIMER_VALUE_SECONDS, (Object)timerValueSeconds);
    }

    public TdmState getGameState() {
        return TdmState.values()[(Integer)this.dataManager.get(GAME_STATE_ORDINAL)];
    }

    public void setGameState(TdmState gameState) {
        this.dataManager.set(GAME_STATE_ORDINAL, (Object)gameState.ordinal());
    }

    public String getDisplayName() {
        return (String)this.dataManager.get(DISPLAY_NAME);
    }

    protected void setDisplayName(String displayName) {
        this.dataManager.set(DISPLAY_NAME, (Object)displayName);
    }

    public TdmPlayerData getPlayerData(UUID playerId) {
        return this.playerData.computeIfAbsent(playerId, __ -> new TdmPlayerData(playerData -> this.dirtyPlayerData.put(playerId, (TdmPlayerData)playerData)));
    }

    public void deletePlayerData(UUID playerId) {
        this.playerData.remove(playerId);
        this.dirtyPlayerData.put(playerId, null);
    }

    @Override
    public GameType getType() {
        return (GameType)GameTypes.TEAM_DEATHMATCH.get();
    }
}

