/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.SynchedData;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;

public class TdmPlayerData
implements Synched {
    private static final DataParameter<Integer> SCORE = new DataParameter(0, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KILLS = new DataParameter(1, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ASSISTS = new DataParameter(2, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DEATHS = new DataParameter(3, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DEAD = new DataParameter(4, DataSerializers.field_187198_h);
    private final SynchedData dataManager = new SynchedData(() -> dirtyListener.accept(this));

    public TdmPlayerData(Consumer<TdmPlayerData> dirtyListener) {
        this.dataManager.register(SCORE, (Object)0);
        this.dataManager.register(KILLS, (Object)0);
        this.dataManager.register(ASSISTS, (Object)0);
        this.dataManager.register(DEATHS, (Object)0);
        this.dataManager.register(DEAD, (Object)false);
    }

    public boolean isDead() {
        return (Boolean)this.dataManager.get(DEAD);
    }

    public void setDead(boolean dead) {
        this.dataManager.set(DEAD, (Object)dead);
    }

    public int getScore() {
        return (Integer)this.dataManager.get(SCORE);
    }

    public void incrementScore() {
        this.dataManager.compute(SCORE, score -> {
            score = score + 1;
            return score;
        });
    }

    public int getKills() {
        return (Integer)this.dataManager.get(KILLS);
    }

    public void incrementKills() {
        this.dataManager.compute(KILLS, kills -> {
            kills = kills + 1;
            return kills;
        });
    }

    public int getAssists() {
        return (Integer)this.dataManager.get(ASSISTS);
    }

    public void incrementAssists() {
        this.dataManager.compute(ASSISTS, assists -> {
            assists = assists + 1;
            return assists;
        });
    }

    public int getDeaths() {
        return (Integer)this.dataManager.get(DEATHS);
    }

    public void incrementDeaths() {
        this.dataManager.compute(DEATHS, deaths -> {
            deaths = deaths + 1;
            return deaths;
        });
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (PacketBuffer)out);
    }

    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack((PacketBuffer)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

