/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.entity.extension.Visibility;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

public class TdmPlayerHandler
implements PlayerHandler {
    public static final ResourceLocation ID = GameTypes.TEAM_DEATHMATCH.getId();
    protected static final DataParameter<Integer> REMAINING_BUY_TIME_SECONDS = new DataParameter(0, DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> REMAINING_SPAWN_PROTECTION_SECONDS = new DataParameter(2, DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> REMAINING_GHOST_TIME_SECONDS = new DataParameter(3, DataSerializers.field_187192_b);
    private final PlayerExtension<?> player;
    protected final SynchedData dataManager = new SynchedData();
    private final TdmGame<?> game;

    public TdmPlayerHandler(TdmGame<?> game, PlayerExtension<?> player) {
        this(game, player, 0, 0, 0);
    }

    public TdmPlayerHandler(TdmGame<?> game, PlayerExtension<?> player, int buyTimeSeconds, int spawnProtectionSeconds, int ghostTimeSeconds) {
        this.game = game;
        this.player = player;
        this.dataManager.register(REMAINING_BUY_TIME_SECONDS, (Object)buyTimeSeconds);
        this.dataManager.register(REMAINING_SPAWN_PROTECTION_SECONDS, (Object)spawnProtectionSeconds);
        this.dataManager.register(REMAINING_GHOST_TIME_SECONDS, (Object)ghostTimeSeconds);
    }

    public PlayerExtension<?> getPlayer() {
        return this.player;
    }

    public Optional<TdmTeam> getTeam() {
        return this.game.getTeamModule().getPlayerTeam(((PlayerEntity)this.player.getEntity()).func_110124_au());
    }

    public int getRemainingBuyTimeSeconds() {
        return (Integer)this.dataManager.get(REMAINING_BUY_TIME_SECONDS);
    }

    public void setRemainingBuyTimeSeconds(int remainingBuyTimeSeconds) {
        this.dataManager.set(REMAINING_BUY_TIME_SECONDS, (Object)remainingBuyTimeSeconds);
    }

    public int getRemainingSpawnProtectionSeconds() {
        return (Integer)this.dataManager.get(REMAINING_SPAWN_PROTECTION_SECONDS);
    }

    public void setRemainingSpawnProtectionSeconds(int spawnProtectionSeconds) {
        this.dataManager.set(REMAINING_SPAWN_PROTECTION_SECONDS, (Object)spawnProtectionSeconds);
    }

    public Visibility getVisibility() {
        return this.getRemainingSpawnProtectionSeconds() > 0 ? Visibility.PARTIALLY_VISIBLE : Visibility.VISIBLE;
    }

    public TdmPlayerData getPlayerData() {
        return this.game.getPlayerData(((PlayerEntity)this.player.getEntity()).func_110124_au());
    }

    public boolean isMovementBlocked() {
        return this.game.isMovementBlocked();
    }

    public boolean isCombatModeEnabled() {
        return true;
    }

    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops) {
        return true;
    }

    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (PacketBuffer)out);
    }

    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack((PacketBuffer)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

