/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.combatslot.CombatSlotType;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.SpawnPoint;
import com.craftingdead.immerse.game.module.ServerModule;
import com.craftingdead.immerse.game.module.shop.ServerShopModule;
import com.craftingdead.immerse.game.module.shop.ShopCategory;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import com.craftingdead.immerse.game.module.team.ServerTeamModule;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmServerPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.message.TdmServerMessage;
import com.craftingdead.immerse.game.tdm.state.GameStateInstance;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import com.craftingdead.immerse.server.LogicalServer;
import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.StateInstance;
import com.craftingdead.immerse.util.state.StateMachine;
import com.craftingdead.immerse.util.state.TimedStateInstance;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;

public class TdmServer
extends TdmGame<ServerModule>
implements GameServer,
ServerTeamModule.TeamHandler<TdmTeam> {
    public static final Codec<TdmServer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("displayName").forGetter(TdmGame::getDisplayName), (App)Codec.INT.optionalFieldOf("maxScore", (Object)100).forGetter(TdmServer::getMaxScore), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("preGameDuration", (Object)Duration.ofMinutes(1L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("gameDuration", (Object)Duration.ofMinutes(10L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("postGameDuration", (Object)Duration.ofSeconds(30L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("buyDuration", (Object)Duration.ofSeconds(20L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("spawnProtectionDuration", (Object)Duration.ofSeconds(8L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("ghostDuration", (Object)Duration.ofSeconds(5L)).forGetter(TdmServer::getPreGameDuration), (App)SpawnPoint.CODEC.fieldOf("redSpawnPoint").forGetter(TdmServer::getRedSpawnPoint), (App)SpawnPoint.CODEC.fieldOf("blueSpawnPoint").forGetter(TdmServer::getBlueSpawnPoint)).apply((Applicative)instance, TdmServer::new));
    private static final ITextComponent NO_SWITCH_TEAM = new TranslationTextComponent("message.no_switch_team");
    private final LogicalServer logicalServer = CraftingDeadImmerse.getInstance().getLogicalServer();
    private final StateMachine<TdmState, TdmServer> stateMachine;
    private ServerShopModule shopModule;
    private ServerTeamModule<TdmTeam> teamModule;
    private final int maxScore;
    private final Duration preGameDuration;
    private final Duration gameDuration;
    private final Duration postGameDuration;
    private final Duration buyDuration;
    private final Duration spawnProtectionDuration;
    private final Duration ghostDuration;
    private final SpawnPoint redSpawnPoint;
    private final SpawnPoint blueSpawnPoint;
    private boolean daylightCycleOld;
    private boolean weatherCycleOld;
    private boolean showDeathMessagesOld;
    private boolean naturalRegenerationOld;
    private boolean immediateRespawnOld;
    private Difficulty oldDifficulty;
    private boolean firstBloodDrawn;
    private boolean finished;

    public TdmServer(String displayName, int maxScore, Duration preGameDuration, Duration gameDuration, Duration postGameDuration, Duration buyDuration, Duration spawnProtectionDuration, Duration ghostDuration, SpawnPoint redSpawnPoint, SpawnPoint blueSpawnPoint) {
        super(displayName);
        this.maxScore = maxScore;
        this.preGameDuration = preGameDuration;
        this.gameDuration = gameDuration;
        this.postGameDuration = postGameDuration;
        this.buyDuration = buyDuration;
        this.spawnProtectionDuration = spawnProtectionDuration;
        this.ghostDuration = ghostDuration;
        this.stateMachine = new StateMachine((Object)this, (State[])TdmState.values(), this::setGameState);
        this.redSpawnPoint = redSpawnPoint;
        this.blueSpawnPoint = blueSpawnPoint;
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public Duration getPreGameDuration() {
        return this.preGameDuration;
    }

    public Duration getGameDuration() {
        return this.gameDuration;
    }

    public Duration getPostGameDuration() {
        return this.postGameDuration;
    }

    public Duration getBuyDuration() {
        return this.buyDuration;
    }

    public Duration getSpawnProtectionDuration() {
        return this.spawnProtectionDuration;
    }

    public Duration getGhostDuration() {
        return this.ghostDuration;
    }

    public SpawnPoint getRedSpawnPoint() {
        return this.redSpawnPoint;
    }

    public SpawnPoint getBlueSpawnPoint() {
        return this.blueSpawnPoint;
    }

    public LogicalServer getLogicalServer() {
        return this.logicalServer;
    }

    public MinecraftServer getMinecraftServer() {
        return this.getLogicalServer().getMinecraftServer();
    }

    public void resetBuyTimes() {
        this.getMinecraftServer().func_184103_al().func_181057_v().stream().map(PlayerExtension::getOrThrow).map(player -> (TdmServerPlayerHandler)player.getHandlerOrThrow(TdmPlayerHandler.ID)).forEach(TdmServerPlayerHandler::resetBuyTime);
    }

    public void resetPlayerData() {
        for (ServerPlayerEntity playerEntity : this.getMinecraftServer().func_184103_al().func_181057_v()) {
            this.deletePlayerData(playerEntity.func_110124_au());
        }
    }

    public void resetTeams() {
        for (TdmTeam team : TdmTeam.values()) {
            TdmTeam.reset(this.getTeamModule().getTeamInstance(team));
        }
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        if (message instanceof TdmServerMessage) {
            ((TdmServerMessage)message).handle(this, context);
        }
    }

    @Override
    public Optional<SpawnPoint> getSpawnPoint(PlayerExtension<ServerPlayerEntity> player) {
        return this.getTeamModule().getPlayerTeam(((ServerPlayerEntity)player.getEntity()).func_110124_au()).map(team -> team == TdmTeam.RED ? this.getRedSpawnPoint() : this.getBlueSpawnPoint());
    }

    @Override
    public void tick() {
        if (this.stateMachine.getCurrentState().getState() == TdmState.IDLE && this.getMinecraftServer().func_71233_x() > 0) {
            this.stateMachine.nextState();
        }
        if (this.stateMachine.getCurrentState() instanceof TimedStateInstance) {
            this.setTimerValueSeconds((int)((TimedStateInstance)this.stateMachine.getCurrentState()).getTimeRemainingSeconds());
        } else {
            this.setTimerValueSeconds(0);
        }
        this.finished = this.stateMachine.tick();
    }

    @Override
    public void load() {
        GameRules gameRules = this.getMinecraftServer().func_200252_aR();
        GameRules.BooleanValue daylightCycle = (GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223607_j);
        this.daylightCycleOld = daylightCycle.func_223572_a();
        daylightCycle.func_223570_a(false, this.getMinecraftServer());
        GameRules.BooleanValue weatherCycle = (GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223617_t);
        this.weatherCycleOld = weatherCycle.func_223572_a();
        weatherCycle.func_223570_a(false, this.getMinecraftServer());
        GameRules.BooleanValue showDeathMessages = (GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223609_l);
        this.showDeathMessagesOld = showDeathMessages.func_223572_a();
        showDeathMessages.func_223570_a(false, this.getMinecraftServer());
        GameRules.BooleanValue naturalRegeneration = (GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223606_i);
        this.naturalRegenerationOld = naturalRegeneration.func_223572_a();
        naturalRegeneration.func_223570_a(false, this.getMinecraftServer());
        GameRules.BooleanValue immediateRespawn = (GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_226683_z_);
        this.immediateRespawnOld = immediateRespawn.func_223572_a();
        immediateRespawn.func_223570_a(true, this.getMinecraftServer());
        ServerWorld world = this.getMinecraftServer().func_71218_a(World.field_234918_g_);
        world.func_241113_a_(6000, 0, false, false);
        world.func_241114_a_(1000L);
        this.oldDifficulty = this.getMinecraftServer().func_240793_aU_().func_176130_y();
        this.getMinecraftServer().func_147139_a(Difficulty.PEACEFUL, true);
        super.load();
    }

    @Override
    public void unload() {
        GameRules gameRules = this.getMinecraftServer().func_200252_aR();
        ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223607_j)).func_223570_a(this.daylightCycleOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223617_t)).func_223570_a(this.weatherCycleOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223609_l)).func_223570_a(this.showDeathMessagesOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223606_i)).func_223570_a(this.naturalRegenerationOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_226683_z_)).func_223570_a(this.immediateRespawnOld, this.getMinecraftServer());
        this.getMinecraftServer().func_147139_a(this.oldDifficulty, true);
        for (ServerPlayerEntity playerEntity : this.getMinecraftServer().func_184103_al().func_181057_v()) {
            ((TdmServerPlayerHandler)PlayerExtension.getOrThrow((PlayerEntity)playerEntity).getHandlerOrThrow(TdmPlayerHandler.ID)).invalidate();
        }
        super.unload();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void addPlayer(PlayerExtension<ServerPlayerEntity> player) {
        ((ServerTeamModule)this.getTeamModule()).setPlayerTeam(player, null);
        GameUtil.sendGameMessageToAll((ITextComponent)new TranslationTextComponent("message.joined", new Object[]{((ServerPlayerEntity)player.getEntity()).func_145748_c_().getString()}), this.getMinecraftServer());
    }

    @Override
    public void removePlayer(PlayerExtension<ServerPlayerEntity> player) {
        ((ServerTeamModule)this.getTeamModule()).setPlayerTeam(player, null);
        this.deletePlayerData(((ServerPlayerEntity)player.getEntity()).func_110124_au());
        GameUtil.sendGameMessageToAll((ITextComponent)new TranslationTextComponent("message.left", new Object[]{((ServerPlayerEntity)player.getEntity()).func_145748_c_().getString()}), this.getMinecraftServer());
    }

    @Override
    public boolean persistPlayerData() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void registerModules(Consumer<ServerModule> registrar) {
        this.shopModule = new ServerShopModule(ServerShopModule.COMBAT_PURCHASE_HANDLER, (int)this.buyDuration.getSeconds());
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("Rifle"), (ITextComponent)new StringTextComponent("Assault rifle selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M4A1.get()), (Object)new ShopItem((Item)ModItems.AK47.get()), (Object)new ShopItem((Item)ModItems.FNFAL.get()), (Object)new ShopItem((Item)ModItems.ACR.get()))));
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("SMG"), (ITextComponent)new StringTextComponent("Sub-machine gun selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.MAC10.get()), (Object)new ShopItem((Item)ModItems.P90.get()), (Object)new ShopItem((Item)ModItems.VECTOR.get()))));
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("Heavy"), (ITextComponent)new StringTextComponent("Heavy-based gun selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.MOSSBERG.get()), (Object)new ShopItem((Item)ModItems.M240B.get()), (Object)new ShopItem((Item)ModItems.M1GARAND.get()))));
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("Sniper"), (ITextComponent)new StringTextComponent("Sniper rifle selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M107.get()), (Object)new ShopItem((Item)ModItems.AS50.get()), (Object)new ShopItem((Item)ModItems.AWP.get()))));
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("Pistol"), (ITextComponent)new StringTextComponent("Side arm and pistol selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M1911.get()), (Object)new ShopItem((Item)ModItems.G18.get()), (Object)new ShopItem((Item)ModItems.DESERT_EAGLE.get()), (Object)new ShopItem((Item)ModItems.P250.get()), (Object)new ShopItem((Item)ModItems.FN57.get()))));
        this.shopModule.addCategory(new ShopCategory((ITextComponent)new StringTextComponent("Grenades"), (ITextComponent)new StringTextComponent("Utilities and grenades."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.FLASH_GRENADE.get()), (Object)new ShopItem((Item)ModItems.DECOY_GRENADE.get()), (Object)new ShopItem((Item)ModItems.SMOKE_GRENADE.get()), (Object)new ShopItem((Item)ModItems.FIRE_GRENADE.get()), (Object)new ShopItem((Item)ModItems.FRAG_GRENADE.get()))));
        registrar.accept(this.shopModule);
        this.teamModule = new ServerTeamModule<TdmTeam>(TdmTeam.class, this);
        registrar.accept(this.teamModule);
        super.registerModules(registrar);
    }

    public ServerTeamModule<TdmTeam> getTeamModule() {
        return this.teamModule;
    }

    @Override
    public boolean canChangeTeam(PlayerExtension<ServerPlayerEntity> player, @Nullable TeamInstance<TdmTeam> oldTeam, @Nullable TeamInstance<TdmTeam> newTeam) {
        if (oldTeam != null && newTeam != null) {
            boolean tooLate;
            StateInstance<TdmServer> stateInstance = this.stateMachine.getCurrentState();
            float maxScore = (float)this.getMaxScore() * 0.75f;
            boolean scoresClose = oldTeam != null && (float)TdmTeam.getScore(oldTeam) > maxScore || (float)TdmTeam.getScore(newTeam) > maxScore;
            boolean bl = tooLate = stateInstance.getState() == TdmState.GAME && ((GameStateInstance)stateInstance).getTimeElapsedSeconds() > 240L || stateInstance.getState() == TdmState.POST_GAME;
            if (scoresClose || tooLate) {
                ((ServerPlayerEntity)player.getEntity()).func_145747_a(GameUtil.formatMessage(NO_SWITCH_TEAM), Util.field_240973_b_);
                return false;
            }
        }
        return true;
    }

    @Override
    public void teamChanged(PlayerExtension<ServerPlayerEntity> player, @Nullable TeamInstance<TdmTeam> oldTeam, @Nullable TeamInstance<TdmTeam> newTeam) {
        if (newTeam == null) {
            ((ServerPlayerEntity)player.getEntity()).field_71071_by.func_174888_l();
            ((ServerPlayerEntity)player.getEntity()).func_71033_a(GameType.SPECTATOR);
        } else {
            this.shopModule.resetBuyTime(((ServerPlayerEntity)player.getEntity()).func_110124_au());
            ((ServerPlayerEntity)player.getEntity()).func_71033_a(GameType.ADVENTURE);
            this.logicalServer.respawnPlayer((ServerPlayerEntity)player.getEntity(), false);
            GameUtil.sendGameMessageToAll((ITextComponent)new TranslationTextComponent("message.joined_team", new Object[]{((ServerPlayerEntity)player.getEntity()).func_145748_c_().getString(), newTeam.getTeam().getDisplayName().getString()}), this.getMinecraftServer());
        }
    }

    @SubscribeEvent
    public void handleLivingLoad(LivingExtensionEvent.Load event) {
        if (event.getLiving() instanceof PlayerExtension && !event.getLiving().getLevel().func_201670_d()) {
            PlayerExtension player = (PlayerExtension)event.getLiving();
            player.registerHandler(TdmPlayerHandler.ID, (LivingHandler)new TdmServerPlayerHandler(this, player));
        }
    }

    @SubscribeEvent
    public void handleLivingDeath(LivingDeathEvent event) {
        if (this.getGameState() == TdmState.GAME && event.getSource().func_76346_g() instanceof ServerPlayerEntity && event.getEntityLiving() instanceof ServerPlayerEntity && !this.firstBloodDrawn) {
            GameUtil.sendGameMessageToAll((ITextComponent)new TranslationTextComponent("message.first_blood_drawn", new Object[]{event.getSource().func_76346_g().func_145748_c_().getString()}).func_240699_a_(TextFormatting.DARK_RED), this.getMinecraftServer());
            this.firstBloodDrawn = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleTriggerPressed(GunEvent.TriggerPressed event) {
        LivingHandler handler = event.getLiving().getHandlerOrThrow(TdmPlayerHandler.ID);
        TdmPlayerHandler player = (TdmPlayerHandler)handler;
        player.setRemainingSpawnProtectionSeconds(0);
    }

    @SubscribeEvent
    public void handleEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getEntity();
            CombatSlotType.MELEE.addToInventory(((Item)ModItems.COMBAT_KNIFE.get()).func_190903_i(), playerEntity.field_71071_by, false);
            this.shopModule.resetBuyTime(event.getEntity().func_110124_au());
        }
    }
}

