/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.module.team.ServerTeamModule;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmServer;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.DisplayKilledMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.network.PacketDistributor;

public class TdmServerPlayerHandler
extends TdmPlayerHandler {
    private static final float ASSIST_DAMAGE_PCT = 0.4f;
    private int secondTicker;
    private PlayerEntity lastSignificantDamage;
    private boolean wasGhost;
    private boolean ghost;
    private ServerPlayerEntity pendingSpectate;
    private TdmServer game;
    private boolean valid = true;

    public TdmServerPlayerHandler(TdmServer game, PlayerExtension<?> player) {
        super(game, player, (int)game.getBuyDuration().getSeconds(), (int)game.getSpawnProtectionDuration().getSeconds(), (int)game.getGhostDuration().getSeconds());
        this.game = game;
    }

    public void resetBuyTime() {
        this.setRemainingBuyTimeSeconds((int)this.game.getBuyDuration().getSeconds());
    }

    public void tick() {
        super.tick();
        if (this.wasGhost != this.ghost) {
            this.wasGhost = this.ghost;
            this.getPlayerData().setDead(this.ghost);
        }
        if (this.ghost && this.pendingSpectate != null) {
            if (this.pendingSpectate.func_70089_S() && !this.pendingSpectate.func_175149_v()) {
                ((ServerPlayerEntity)this.getPlayer().getEntity()).func_175399_e((Entity)this.pendingSpectate);
            }
            this.pendingSpectate = null;
        }
        if (this.secondTicker++ == 20) {
            this.secondTicker = 0;
            if (this.ghost) {
                if ((Integer)this.dataManager.compute(REMAINING_GHOST_TIME_SECONDS, ghostTime -> {
                    ghostTime = ghostTime - 1;
                    return ghostTime;
                }) <= 0) {
                    this.ghost = false;
                    ((PlayerEntity)this.getPlayer().getEntity()).func_71033_a(GameType.ADVENTURE);
                    this.game.getLogicalServer().respawnPlayer((ServerPlayerEntity)this.getPlayer().getEntity(), false);
                }
            } else if (!((PlayerEntity)this.getPlayer().getEntity()).func_175149_v()) {
                this.dataManager.compute(REMAINING_BUY_TIME_SECONDS, buyTime -> buyTime > 0 ? (buyTime = Integer.valueOf(buyTime - 1)) : buyTime);
                this.dataManager.compute(REMAINING_SPAWN_PROTECTION_SECONDS, spawnProtection -> {
                    int n;
                    if (spawnProtection > 0) {
                        Integer n2;
                        spawnProtection = spawnProtection - 1;
                        if ((float)n2.intValue() < (float)this.game.getSpawnProtectionDuration().getSeconds() * 0.8f && this.getPlayer().isMoving()) {
                            n = 0;
                            return n;
                        }
                    }
                    n = spawnProtection;
                    return n;
                });
            }
        }
    }

    public boolean handleHurt(DamageSource source, float amount) {
        if (this.getRemainingSpawnProtectionSeconds() > 0 || this.isMovementBlocked()) {
            return true;
        }
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)source.func_76346_g();
            if (playerEntity.func_184614_ca().func_190926_b()) {
                return true;
            }
            if (amount > ((PlayerEntity)this.getPlayer().getEntity()).func_110138_aP() * 0.4f) {
                this.lastSignificantDamage = playerEntity;
            }
            if (playerEntity.getCapability(Capabilities.LIVING_EXTENSION).resolve().flatMap(e -> e.getHandler(ID)).map(extension -> ((TdmPlayerHandler)extension).getTeam().orElse(null) == this.getTeam().orElse(null)).orElse(false).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public boolean handleKill(Entity target) {
        if (target instanceof ServerPlayerEntity) {
            TdmPlayerData playerData = this.getPlayerData();
            playerData.incrementKills();
            playerData.incrementScore();
            this.getTeam().map(((ServerTeamModule)this.game.getTeamModule())::getTeamInstance).ifPresent(TdmTeam::incrementScore);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)target), (Object)new DisplayKilledMessage(((PlayerEntity)this.getPlayer().getEntity()).func_145782_y(), ((PlayerEntity)this.getPlayer().getEntity()).func_184614_ca()));
        }
        return false;
    }

    public boolean handleDeath(DamageSource cause) {
        if (this.getPlayer().getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)this.getPlayer().getEntity();
            this.getPlayerData().incrementDeaths();
            if (this.lastSignificantDamage != null && this.lastSignificantDamage != cause.func_76346_g()) {
                this.game.getPlayerData(this.lastSignificantDamage.func_110124_au()).incrementAssists();
            }
            this.ghost = true;
            playerEntity.func_71121_q().func_195594_a((IParticleData)ParticleTypes.field_197627_t, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), 0.0, 0.0, 0.0);
            playerEntity.func_71033_a(GameType.SPECTATOR);
            if (cause.func_76346_g() instanceof ServerPlayerEntity) {
                this.pendingSpectate = (ServerPlayerEntity)cause.func_76346_g();
            }
        }
        return false;
    }

    public void copyFrom(PlayerExtension<?> that, boolean wasDeath) {
        TdmServerPlayerHandler extension = (TdmServerPlayerHandler)that.getHandlerOrThrow(ID);
        if (extension.valid) {
            this.wasGhost = extension.wasGhost;
            this.ghost = extension.ghost;
            this.pendingSpectate = extension.pendingSpectate;
        }
    }

    public void invalidate() {
        this.valid = false;
    }
}

