/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public enum TdmTeam implements Team
{
    RED("Red", TextFormatting.RED.func_211163_e(), new ResourceLocation("craftingdeadimmerse", "textures/skins/red_team.png")),
    BLUE("Blue", TextFormatting.BLUE.func_211163_e(), new ResourceLocation("craftingdeadimmerse", "textures/skins/blue_team.png"));

    private static final DataParameter<Integer> SCORE;
    private final String name;
    private final int colour;
    private final ResourceLocation skin;

    private TdmTeam(String name, int colour, ResourceLocation skin) {
        this.name = name;
        this.colour = colour;
        this.skin = skin;
    }

    public static void incrementScore(TeamInstance<?> team) {
        team.getDataManager().compute(SCORE, score -> {
            score = score + 1;
            return score;
        });
    }

    public static int getScore(TeamInstance<?> teamInstance) {
        return (Integer)teamInstance.getDataManager().get(SCORE);
    }

    public static void reset(TeamInstance<?> teamInstance) {
        teamInstance.getDataManager().set(SCORE, (Object)0);
    }

    @Override
    public Optional<ResourceLocation> getSkin() {
        return Optional.of(this.skin);
    }

    @Override
    public void registerDataParameters(SynchedData dataManager) {
        dataManager.register(SCORE, (Object)0);
    }

    @Override
    public void save(TeamInstance<?> teamInstance, CompoundNBT nbt) {
    }

    @Override
    public void load(TeamInstance<?> teamInstance, CompoundNBT nbt) {
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        SCORE = new DataParameter(0, DataSerializers.field_187192_b);
    }
}

