/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm.state;

import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import com.craftingdead.immerse.game.tdm.TdmServer;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.TimedStateInstance;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GameStateInstance
extends TimedStateInstance<TdmServer> {
    private static final ITextComponent TIE_GAME = new StringTextComponent("Tie Game!");
    private static final ITextComponent SPACE = new StringTextComponent(" ");
    private static final ITextComponent WON = new StringTextComponent("Won!");
    private static final ITextComponent DEATHMATCH = new StringTextComponent("Deathmatch");

    public GameStateInstance(State<?> state, TdmServer context) {
        super(state, context, context.getGameDuration());
    }

    @Override
    public boolean tick() {
        if (this.getTimeRemainingSeconds() <= 20L && this.hasSecondPast()) {
            GameUtil.broadcastSound((SoundEvent)ImmerseSoundEvents.COUNTDOWN.get(), ((TdmServer)this.getContext()).getMinecraftServer());
        }
        TeamInstance<TdmTeam> redTeam = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.RED);
        TeamInstance<TdmTeam> blueTeam = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.BLUE);
        if (TdmTeam.getScore(redTeam) >= ((TdmServer)this.getContext()).getMaxScore() ^ TdmTeam.getScore(blueTeam) >= ((TdmServer)this.getContext()).getMaxScore()) {
            this.finishGame(redTeam, blueTeam);
            return true;
        }
        if (super.tick()) {
            this.finishGame(redTeam, blueTeam);
            return true;
        }
        return false;
    }

    private void finishGame(TeamInstance<?> redTeam, TeamInstance<?> blueTeam) {
        IFormattableTextComponent winnerText;
        TdmTeam winningTeam = ((TdmServer)this.getContext()).getWinningTeam().orElse(null);
        ((TdmServer)this.getContext()).setMovementBlocked(true);
        if (winningTeam == null) {
            winnerText = TIE_GAME.func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.BOLD});
            redTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.RED_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
            blueTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.BLUE_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
        } else {
            winnerText = winningTeam.getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.BOLD).func_230529_a_(SPACE).func_230529_a_(WON);
            switch (winningTeam) {
                case RED: {
                    redTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.RED_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    blueTeam.broadcastDefeatSounds((SoundEvent)ImmerseSoundEvents.BLUE_DEFEAT.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    break;
                }
                case BLUE: {
                    blueTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.BLUE_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    redTeam.broadcastDefeatSounds((SoundEvent)ImmerseSoundEvents.RED_DEFEAT.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    break;
                }
            }
        }
        this.sendWinAnnoucement((ITextComponent)winnerText, TdmTeam.getScore(redTeam), TdmTeam.getScore(blueTeam));
    }

    private void sendWinAnnoucement(ITextComponent winnerText, int redScore, int blueScore) {
        IFormattableTextComponent scores = new StringTextComponent("Red: " + redScore + "    Blue: " + blueScore).func_240701_a_(new TextFormatting[]{TextFormatting.RESET, TextFormatting.ITALIC});
        GameUtil.sendChatAnnouncement(DEATHMATCH, (ITextComponent)winnerText.func_230532_e_().func_230529_a_(GameUtil.NEW_LINE).func_230529_a_((ITextComponent)scores), ((TdmServer)this.getContext()).getMinecraftServer());
    }
}

