/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.mixin;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.Game;
import java.util.Random;
import net.minecraft.block.FireBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBlock.class})
public class FireBlockMixin {
    @Inject(method={"tryCatchFire"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tryCatchFire(World level, BlockPos pos, int chance, Random random, int age, Direction face, CallbackInfo callbackInfo) {
        if (this.blockBurningDisabled(level)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"canCatchFire"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canCatchFire(IBlockReader blockGetter, BlockPos pos, Direction face, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (blockGetter instanceof World && this.blockBurningDisabled((World)blockGetter)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    private boolean blockBurningDisabled(World level) {
        Game<?> game = CraftingDeadImmerse.getInstance().getGame(level.func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER);
        return game != null && game.disableBlockBurning();
    }
}

