/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.mixin;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.SpawnPoint;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerEntity.class})
public class ServerPlayerEntityMixin {
    @Inject(method={"getRespawnPosition"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRespawnPosition(CallbackInfoReturnable<BlockPos> callbackInfo) {
        this.getSpawnPoint().map(SpawnPoint::getBlockPos).ifPresent(arg_0 -> callbackInfo.setReturnValue(arg_0));
    }

    @Inject(method={"getRespawnDimension"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRespawnDimension(CallbackInfoReturnable<RegistryKey<World>> callbackInfo) {
        this.getSpawnPoint().map(SpawnPoint::getDimension).ifPresent(arg_0 -> callbackInfo.setReturnValue(arg_0));
    }

    @Inject(method={"isRespawnForced"}, at={@At(value="HEAD")}, cancellable=true)
    public void isRespawnForced(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.getSpawnPoint().isPresent()) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    private Optional<SpawnPoint> getSpawnPoint() {
        return CraftingDeadImmerse.getInstance().getLogicalServer().getGame().getSpawnPoint((PlayerExtension<ServerPlayerEntity>)PlayerExtension.getOrThrow((PlayerEntity)((ServerPlayerEntity)this)));
    }
}

