/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.network;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.network.login.AcknowledgeGameMessage;
import com.craftingdead.immerse.network.login.LoginIndexedMessage;
import com.craftingdead.immerse.network.login.SetupGameMessage;
import com.craftingdead.immerse.network.play.ChangeGameMessage;
import com.craftingdead.immerse.network.play.DisplayKilledMessage;
import com.craftingdead.immerse.network.play.SyncGameMessage;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public enum NetworkChannel {
    LOGIN(new ResourceLocation("craftingdeadimmerse", "login")){

        @Override
        protected void registerMessages(SimpleChannel simpleChannel) {
            simpleChannel.messageBuilder(SetupGameMessage.class, 0, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(LoginIndexedMessage::getLoginIndex, LoginIndexedMessage::setLoginIndex).encoder(SetupGameMessage::encode).decoder(SetupGameMessage::decode).consumer(FMLHandshakeHandler.biConsumerFor((handler, msg, ctx) -> SetupGameMessage.handle(msg, ctx))).buildLoginPacketList(isLocal -> CraftingDeadImmerse.getInstance().getLogicalServer().generateSetupGameMessage((boolean)isLocal)).add();
            simpleChannel.messageBuilder(AcknowledgeGameMessage.class, 1, NetworkDirection.LOGIN_TO_SERVER).loginIndex(LoginIndexedMessage::getLoginIndex, LoginIndexedMessage::setLoginIndex).encoder(AcknowledgeGameMessage::encode).decoder(AcknowledgeGameMessage::decode).consumer(FMLHandshakeHandler.indexFirst((handler, msg, ctx) -> AcknowledgeGameMessage.handle(msg, ctx))).add();
        }
    }
    ,
    PLAY(new ResourceLocation("craftingdeadimmerse", "play")){

        @Override
        protected void registerMessages(SimpleChannel simpleChannel) {
            simpleChannel.messageBuilder(ChangeGameMessage.class, 0, NetworkDirection.PLAY_TO_CLIENT).encoder(ChangeGameMessage::encode).decoder(ChangeGameMessage::decode).consumer(ChangeGameMessage::handle).add();
            simpleChannel.messageBuilder(DisplayKilledMessage.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(DisplayKilledMessage::encode).decoder(DisplayKilledMessage::decode).consumer(DisplayKilledMessage::handle).add();
            simpleChannel.messageBuilder(SyncGameMessage.class, 2, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncGameMessage::encode).decoder(SyncGameMessage::decode).consumer(SyncGameMessage::handle).add();
        }
    };

    private static final String NETWORK_VERSION = "0.0.1.0";
    private static boolean loaded;
    private final SimpleChannel simpleChannel;

    private NetworkChannel(ResourceLocation channelName) {
        this.simpleChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(NETWORK_VERSION::equals).serverAcceptedVersions(NETWORK_VERSION::equals).networkProtocolVersion(() -> NETWORK_VERSION).simpleChannel();
    }

    protected abstract void registerMessages(SimpleChannel var1);

    public SimpleChannel getSimpleChannel() {
        return this.simpleChannel;
    }

    public static void loadChannels() {
        if (!loaded) {
            for (NetworkChannel channel : NetworkChannel.values()) {
                channel.registerMessages(channel.simpleChannel);
            }
            loaded = true;
        }
    }
}

