/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.network.login;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.login.AcknowledgeGameMessage;
import com.craftingdead.immerse.network.login.LoginIndexedMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SetupGameMessage
extends LoginIndexedMessage {
    private final GameType gameType;

    public SetupGameMessage(GameType gameType) {
        this.gameType = gameType;
    }

    public static void encode(SetupGameMessage msg, PacketBuffer out) {
        out.writeRegistryId((IForgeRegistryEntry)msg.gameType);
    }

    public static SetupGameMessage decode(PacketBuffer in) {
        return new SetupGameMessage((GameType)in.readRegistryId());
    }

    public static void handle(SetupGameMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CraftingDeadImmerse.getInstance().getClientDist().loadGame(msg.gameType));
        ctx.get().setPacketHandled(true);
        NetworkChannel.LOGIN.getSimpleChannel().reply((Object)new AcknowledgeGameMessage(), ctx.get());
    }
}

