/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.server;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.ServerGameWrapper;
import com.craftingdead.immerse.game.survival.SurvivalServer;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.login.SetupGameMessage;
import com.craftingdead.immerse.network.play.ChangeGameMessage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogicalServer
extends WorldSavedData {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new Gson();
    private final MinecraftServer minecraftServer;
    private static final FolderName GAME_FOLDER_NAME = new FolderName("games");
    private final Path gamePath;
    private ServerGameWrapper gameWrapper;
    private String currentGameName;

    public LogicalServer(MinecraftServer minecraftServer) {
        super("craftingdeadimmerse");
        this.minecraftServer = minecraftServer;
        this.gamePath = minecraftServer.func_240776_a_(GAME_FOLDER_NAME);
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public ServerGameWrapper getGameWrapper() {
        return this.gameWrapper;
    }

    public GameServer getGame() {
        return (GameServer)this.gameWrapper.getGame();
    }

    public List<Pair<String, SetupGameMessage>> generateSetupGameMessage(boolean isLocal) {
        return Collections.singletonList(Pair.of((Object)SetupGameMessage.class.getName(), (Object)new SetupGameMessage(this.getGame().getType())));
    }

    public void startLoading() {
    }

    public void finishLoading() {
        this.minecraftServer.func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(() -> this, "craftingdeadimmerse");
        if (this.gameWrapper == null) {
            this.loadNextGame(true);
        }
    }

    private void loadNextGame(boolean loadFirst) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> gameRotationConfig = CraftingDeadImmerse.serverConfig.gameRotation;
        List gameRotation = (List)gameRotationConfig.get();
        if (gameRotation.isEmpty()) {
            logger.info("Game rotation empty, defaulting to survival...");
            this.loadGame(new ServerGameWrapper(new SurvivalServer(), this));
            return;
        }
        String nextGameName = loadFirst || this.gameWrapper == null || this.currentGameName == null ? (String)gameRotation.get(0) : (String)gameRotation.get((gameRotation.indexOf(this.currentGameName) + 1) % gameRotation.size());
        if (!this.findAndLoadGame(nextGameName)) {
            logger.info("Removing game '{}' from game rotation", (Object)nextGameName);
            gameRotation.remove(nextGameName);
            gameRotationConfig.save();
            this.loadNextGame(false);
        }
    }

    private boolean findAndLoadGame(String gameName) {
        GameServer gameServer;
        File gameFile = new File(this.gamePath.toFile(), gameName + ".json");
        if (!gameFile.exists()) {
            logger.error("Game file with name '{}' does not exist");
            return false;
        }
        try (FileReader fileReader = new FileReader(gameFile);){
            gameServer = (GameServer)GameServer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, gson.fromJson((Reader)fileReader, JsonElement.class)).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
        }
        catch (Throwable t) {
            logger.error("Failed to load game file '{}'", (Object)gameFile.toString(), (Object)t);
            return false;
        }
        this.loadGame(new ServerGameWrapper(gameServer, this));
        this.currentGameName = gameName;
        return true;
    }

    private void loadGame(ServerGameWrapper gameWrapper) {
        List players = this.minecraftServer.func_184103_al().func_181057_v();
        ServerGameWrapper oldGameWrapper = this.gameWrapper;
        if (oldGameWrapper != null) {
            logger.info("Unloading current game");
            players.stream().map(PlayerExtension::getOrThrow).forEach(oldGameWrapper::removePlayer);
            oldGameWrapper.unload();
        }
        logger.info("Loading game type '{}'", (Object)((GameServer)gameWrapper.getGame()).getType().getRegistryName().toString());
        this.gameWrapper = gameWrapper;
        gameWrapper.load();
        logger.info("Loading players");
        for (ServerPlayerEntity playerEntity : players) {
            playerEntity.field_71135_a.func_147359_a(NetworkChannel.PLAY.getSimpleChannel().toVanillaPacket((Object)new ChangeGameMessage(((GameServer)gameWrapper.getGame()).getType()), NetworkDirection.PLAY_TO_CLIENT));
            if (oldGameWrapper == null || !((GameServer)gameWrapper.getGame()).persistPlayerData() || ((GameServer)oldGameWrapper.getGame()).persistPlayerData()) continue;
            this.minecraftServer.func_184103_al().func_72380_a(playerEntity);
        }
        players.stream().map(PlayerExtension::getOrThrow).forEach(gameWrapper::addPlayer);
        logger.info("Respawning players");
        this.respawnPlayers(((GameServer)gameWrapper.getGame()).persistPlayerData());
    }

    public void reloadGameRotation() {
        this.loadNextGame(true);
    }

    public void restartGame() {
        this.loadGame(this.gameWrapper);
    }

    public void respawnPlayers(boolean keepData) {
        this.respawnPlayers(player -> true, keepData);
    }

    public void respawnPlayers(Predicate<ServerPlayerEntity> predicate, boolean keepData) {
        ArrayList players = new ArrayList(this.minecraftServer.func_184103_al().func_181057_v());
        for (ServerPlayerEntity playerEntity : players) {
            if (!predicate.test(playerEntity)) continue;
            this.respawnPlayer(playerEntity, keepData);
        }
    }

    public void respawnPlayer(ServerPlayerEntity playerEntity, boolean keepData) {
        playerEntity.field_71135_a.field_147369_b = this.minecraftServer.func_184103_al().func_232644_a_(playerEntity, keepData);
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT gameNbt = nbt.func_74775_l("game");
        if (!gameNbt.isEmpty()) {
            GameServer gameServer = (GameServer)GameServer.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gameNbt).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
            this.loadGame(new ServerGameWrapper(gameServer, this));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        if (this.getGame().save()) {
            nbt.func_218657_a("game", (INBT)GameServer.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.getGame()).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        return nbt;
    }

    @SubscribeEvent
    public void handleServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.gameWrapper.tick();
                if (!this.getGame().isFinished()) break;
                this.loadNextGame(false);
                break;
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getPlayer();
        this.gameWrapper.addPlayer((PlayerExtension<ServerPlayerEntity>)PlayerExtension.getOrThrow((PlayerEntity)playerEntity));
    }

    @SubscribeEvent
    public void handlePlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.gameWrapper.removePlayer((PlayerExtension<ServerPlayerEntity>)PlayerExtension.getOrThrow((PlayerEntity)((ServerPlayerEntity)event.getPlayer())));
    }
}

