/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DependencyLoader {
    private static final String MOD_JAR_URL_PROTOCOL = "modjar";
    private static final String DEPENDENCIES_DIR = "dependencies";
    private static final Logger logger = LogManager.getLogger();

    public static void loadDependencies() {
        if (FMLLoader.isProduction()) {
            logger.info("Loading dependencies");
            ModFile modFile = ModList.get().getModFileById("craftingdeadimmerse").getFile();
            Path resolvedDir = modFile.findResource(DEPENDENCIES_DIR);
            try (Stream<Path> paths = Files.walk(resolvedDir, new FileVisitOption[0]);){
                paths.filter(p -> p.toString().endsWith(".jar")).map(DependencyLoader::toModJarUrl).forEach(DependencyLoader::addUrlToClassLoader);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to search for dependency jars", e);
            }
            logger.info("Finished loading dependencies");
        }
    }

    private static URL toModJarUrl(Path modJarPath) {
        try {
            return new URL(MOD_JAR_URL_PROTOCOL, "craftingdeadimmerse", modJarPath.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to parse mod jar URL", e);
        }
    }

    private static void addUrlToClassLoader(URL url) {
        try {
            URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
            addURLMethod.invoke((Object)classLoader, url);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to add URL to system class loader", t);
        }
    }
}

