/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.util.state;

import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.StateInstance;
import java.time.Duration;

public class TimedStateInstance<CTX>
extends StateInstance<CTX> {
    private final long durationTicks;
    private long timeRemainingTicks;

    public TimedStateInstance(State<?> state, CTX context, Duration duration) {
        this(state, context, duration.getSeconds() * 20L);
    }

    public TimedStateInstance(State<?> state, CTX context, long durationTicks) {
        super(state, context);
        this.durationTicks = durationTicks;
        this.timeRemainingTicks = durationTicks;
    }

    @Override
    protected boolean tick() {
        boolean finished;
        if (super.tick()) {
            return true;
        }
        boolean bl = finished = this.timeRemainingTicks <= 0L;
        if (finished) {
            return true;
        }
        --this.timeRemainingTicks;
        return false;
    }

    public boolean hasSecondPast() {
        return (float)this.getTimeRemainingTicks() % 20.0f == 0.0f;
    }

    public long getTimeRemainingTicks() {
        return this.timeRemainingTicks;
    }

    public void setTimeRemainingTicks(long timeRemainingTicks) {
        this.timeRemainingTicks = timeRemainingTicks;
    }

    public long getTimeRemainingSeconds() {
        return this.getTimeRemainingTicks() / 20L;
    }

    public void setTimeRemainingSeconds(long timeRemainingSeconds) {
        this.setTimeRemainingTicks(timeRemainingSeconds * 20L);
    }

    public long getTimeElapsedTicks() {
        return this.durationTicks - this.timeRemainingTicks;
    }

    public long getTimeElapsedSeconds() {
        return this.getTimeElapsedTicks() / 20L;
    }
}

