/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level;

import com.google.common.base.Splitter;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateUtil {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    @Nullable
    public static BlockState getBlockStateFromString(String str) {
        int index = str.indexOf("[");
        String blockIdString = index != -1 ? str.substring(0, index) : str;
        ResourceLocation blockId = new ResourceLocation(blockIdString);
        if (ForgeRegistries.BLOCKS.containsKey(blockId)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
            BlockState blockState = block.func_176223_P();
            if (index != -1 && str.length() > index + 4 && str.charAt(str.length() - 1) == ']') {
                StateContainer stateContainer = block.func_176194_O();
                String propertyString = str.substring(index + 1, str.length() - 1);
                for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propertyString)) {
                    Comparable value;
                    Property property;
                    Iterator valueIterator = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                    if (!valueIterator.hasNext() || (property = stateContainer.func_185920_a((String)valueIterator.next())) == null || !valueIterator.hasNext() || (value = (Comparable)property.func_185929_b((String)valueIterator.next()).orElse(null)) == null) continue;
                    blockState = BlockStateUtil.setValue(blockState, property, value);
                }
            }
            return blockState;
        }
        return null;
    }

    public static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> prop, Comparable<?> value) {
        return (BlockState)state.func_206870_a(prop, value);
    }
}

