/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.levelgen;

import com.craftingdead.immerse.world.level.SchematicBlockGetter;
import com.craftingdead.immerse.world.level.schematic.Schematic;
import com.mojang.serialization.Codec;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class SchematicChunkGenerator
extends ChunkGenerator {
    private final Schematic schematic;

    public SchematicChunkGenerator(Schematic schematic, DimensionStructuresSettings dimensionStructureSettings) {
        super((BiomeProvider)new SchematicBiomeProvider(schematic), dimensionStructureSettings);
        this.schematic = schematic;
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunk) {
    }

    public void func_230350_a_(long seed, BiomeManager biomeManagerIn, IChunk chunkIn, GenerationStage.Carving carvingStage) {
    }

    public int func_205470_d() {
        for (int y = 0; y < this.schematic.getHeight(); ++y) {
            BlockState blockState = this.schematic.getBlockState(new BlockPos(0, y, 0));
            if (Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(blockState)) continue;
            return y - 1;
        }
        return this.schematic.getHeight();
    }

    public void func_230352_b_(IWorld world, StructureManager structureManager, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.Mutable relativeBlockPos = new BlockPos.Mutable();
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        Heightmap oceanFloorHeightmap = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceHeightMap = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = (chunkPos.field_77276_a << 4) + x;
                int worldZ = (chunkPos.field_77275_b << 4) + z;
                if (worldX < 0 || worldX >= this.schematic.getWidth() || worldZ < 0 || worldZ >= this.schematic.getLength()) continue;
                for (int y = 0; y < this.schematic.getHeight(); ++y) {
                    relativeBlockPos.func_181079_c(x, y, z);
                    blockPos.func_181079_c(worldX, y, worldZ);
                    BlockState blockState = this.schematic.getBlockState((BlockPos)blockPos);
                    chunk.func_177436_a((BlockPos)relativeBlockPos, blockState, false);
                    oceanFloorHeightmap.func_202270_a(x, y, z, blockState);
                    worldSurfaceHeightMap.func_202270_a(x, y, z, blockState);
                    TileEntity tileEntity = this.schematic.getTileEntity((BlockPos)blockPos);
                    if (tileEntity == null) continue;
                    chunk.func_177426_a((BlockPos)relativeBlockPos, tileEntity);
                }
            }
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        for (int y = 0; y < this.schematic.getHeight(); ++y) {
            BlockState blockState = this.schematic.getBlockState(new BlockPos(x, y, z));
            if (!heightmapType.func_222684_d().test(blockState)) continue;
            return y + 1;
        }
        return 0;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return Codec.unit((Object)((Object)this));
    }

    public ChunkGenerator func_230349_a_(long seed) {
        return this;
    }

    public IBlockReader func_230348_a_(int x, int z) {
        return new SchematicBlockGetter(this.schematic);
    }

    private static class SchematicBiomeProvider
    extends BiomeProvider {
        private final Schematic schematic;

        protected SchematicBiomeProvider(Schematic schematic) {
            super(schematic.getBiomes());
            this.schematic = schematic;
        }

        public Biome func_225526_b_(int x, int y, int z) {
            return this.schematic.getBiome(x, y, z);
        }

        protected Codec<? extends BiomeProvider> func_230319_a_() {
            return Codec.unit((Object)((Object)this));
        }

        public BiomeProvider func_230320_a_(long seed) {
            return this;
        }
    }
}

