/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.schematic.sponge;

import com.craftingdead.immerse.world.level.BlockStateUtil;
import com.craftingdead.immerse.world.level.schematic.NBTSchematicType;
import com.craftingdead.immerse.world.level.schematic.sponge.SpongeSchematic;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpongeSchematicType
extends NBTSchematicType<SpongeSchematic> {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<Integer, IVersionReader> versionReaders = ImmutableMap.of((Object)2, (Object)new Version2());

    @Override
    protected SpongeSchematic read(CompoundNBT nbt) throws IOException {
        IVersionReader versionReader;
        int version = nbt.func_74762_e("Version");
        if (version == 0) {
            throw new IOException("Version tag required.");
        }
        int dataVersion = nbt.func_74762_e("DataVersion");
        if (dataVersion != SharedConstants.func_215069_a().getWorldVersion()) {
            logger.warn("Schematic was made in a different version of Minecraft (schematic_version={}, game_version={}). Data may be incompatible.", (Object)dataVersion, (Object)SharedConstants.func_215069_a().getWorldVersion());
        }
        if ((versionReader = versionReaders.get(version)) != null) {
            return versionReader.read(nbt);
        }
        throw new IOException("Unsupported schematic version");
    }

    private static class Version2
    implements IVersionReader {
        private Version2() {
        }

        @Override
        public SpongeSchematic read(CompoundNBT nbt) throws IOException {
            int width = NBTSchematicType.getExpectedTag(nbt, "Width", ShortNBT.class).func_150287_d();
            int height = NBTSchematicType.getExpectedTag(nbt, "Height", ShortNBT.class).func_150287_d();
            int length = NBTSchematicType.getExpectedTag(nbt, "Length", ShortNBT.class).func_150287_d();
            CompoundNBT metadataNbt = nbt.func_74775_l("Metadata");
            return new SpongeSchematic.Builder().setWidth(width).setHeight(height).setLength(length).setPalette(this.readPalette(nbt.func_74775_l("Palette")).orElse(null)).setBlockData(Version2.convertVarIntArray(NBTSchematicType.getExpectedTag(nbt, "BlockData", ByteArrayNBT.class).func_150292_c())).setBiomePalette(this.readBiomePalette(nbt.func_74775_l("BiomePalette")).orElse(null)).setBiomeData(Version2.convertVarIntArray(nbt.func_74770_j("BiomeData"))).setTileEntities(this.readTileEntities(nbt.func_150295_c("BlockEntities", 10))).metadata().setName(metadataNbt.func_74779_i("Name")).setAuthor(metadataNbt.func_74779_i("Author")).setDateCreated(metadataNbt.func_150297_b("Date", 4) ? new Date(metadataNbt.func_74763_f("Date")) : null).and().build();
        }

        protected static int[] convertVarIntArray(byte[] array) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int value = 0;
            int length = 0;
            for (int i = 0; i < array.length; ++i) {
                value = 0;
                length = 0;
                while (true) {
                    value |= (array[i] & 0x7F) << length++ * 7;
                    if (length > 5) {
                        throw new RuntimeException("VarInt too big (probably corrupted data)");
                    }
                    if ((array[i] & 0x80) != 128) {
                        break;
                    }
                    ++i;
                }
                list.add(value);
            }
            return Ints.toArray(list);
        }

        protected Optional<Map<Integer, BlockState>> readPalette(CompoundNBT nbt) throws IOException {
            int size = nbt.func_150296_c().size();
            Int2ObjectArrayMap palette = new Int2ObjectArrayMap(size);
            for (String key : nbt.func_150296_c()) {
                int id = nbt.func_74762_e(key);
                BlockState blockState = BlockStateUtil.getBlockStateFromString(key);
                if (blockState == null) {
                    logger.warn("Unknown block state \"{}\"", (Object)key);
                    blockState = Blocks.field_150350_a.func_176223_P();
                }
                if (id < 0 || id >= size) {
                    logger.warn("Block state id out of range \"{}\"", (Object)id);
                    return Optional.empty();
                }
                palette.put(id, blockState);
            }
            return Optional.of(palette);
        }

        protected Optional<Map<Integer, Biome>> readBiomePalette(CompoundNBT nbt) throws IOException {
            int size = nbt.func_150296_c().size();
            Int2ObjectArrayMap palette = new Int2ObjectArrayMap(size);
            for (String key : nbt.func_150296_c()) {
                int id = nbt.func_74762_e(key);
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(key));
                if (biome == null) {
                    logger.warn("Unknown biome \"{}\"", (Object)key);
                    biome = BiomeRegistry.field_244201_b;
                }
                if (id < 0 || id >= size) {
                    logger.warn("Biome id out of range \"{}\"", (Object)id);
                    return Optional.empty();
                }
                palette.put(id, biome);
            }
            return Optional.of(palette);
        }

        protected Map<BlockPos, TileEntity> readTileEntities(ListNBT nbt) throws IOException {
            HashMap<BlockPos, TileEntity> tileEntities = new HashMap<BlockPos, TileEntity>();
            for (int i = 0; i < nbt.size(); ++i) {
                CompoundNBT entry = nbt.func_150305_b(i);
                ResourceLocation id = new ResourceLocation(NBTSchematicType.getExpectedTag(entry, "Id", StringNBT.class).func_150285_a_());
                CompoundNBT tileEntityNbt = entry.func_74737_b();
                tileEntityNbt.func_82580_o("Id");
                tileEntityNbt.func_74778_a("id", id.toString());
                int[] blockPos = tileEntityNbt.func_74759_k("Pos");
                tileEntityNbt.func_74768_a("x", blockPos[0]);
                tileEntityNbt.func_74768_a("y", blockPos[1]);
                tileEntityNbt.func_74768_a("z", blockPos[2]);
                tileEntityNbt.func_82580_o("Pos");
                TileEntityType tileEntityType = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(id);
                if (tileEntityType == null) {
                    logger.warn("Unknown tile entity \"{}\"", (Object)id.toString());
                    continue;
                }
                TileEntity tileEntity = tileEntityType.func_200968_a();
                if (tileEntity == null) {
                    logger.warn("Cannot create tile entity \"{}\"", (Object)id.toString());
                    continue;
                }
                tileEntity.func_230337_a_(null, tileEntityNbt);
                tileEntities.put(tileEntity.func_174877_v(), tileEntity);
            }
            return tileEntities;
        }
    }

    private static interface IVersionReader {
        public SpongeSchematic read(CompoundNBT var1) throws IOException;
    }
}

