/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeycardReaderBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public KeycardReaderBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            KeycardReaderTileEntity te = (KeycardReaderTileEntity)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new TranslationTextComponent(this.func_149739_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
            } else {
                boolean isCodebreaker;
                ItemStack stack = player.func_184586_b(hand);
                Item item = stack.func_77973_b();
                boolean bl = isCodebreaker = item == SCContent.CODEBREAKER.get();
                if (!(item instanceof KeycardItem && stack.func_77942_o() && stack.func_77978_p().func_74767_n("linked") || isCodebreaker)) {
                    if (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos);
                    }
                } else if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    if (isCodebreaker) {
                        if (!player.func_184812_l_()) {
                            stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                        }
                        if (new Random().nextInt(3) == 1) {
                            KeycardReaderBlock.activate(world, pos, te.getSignalLength());
                        }
                    } else {
                        IFormattableTextComponent feedback = this.insertCard(world, pos, te, stack, player);
                        if (feedback != null) {
                            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new TranslationTextComponent(this.func_149739_a()), feedback, TextFormatting.RED);
                        }
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public IFormattableTextComponent insertCard(World world, BlockPos pos, KeycardReaderTileEntity te, ItemStack stack, PlayerEntity player) {
        CompoundNBT tag = stack.func_77978_p();
        if (!te.getOwner().getUUID().equals(tag.func_74779_i("ownerUUID"))) {
            return new TranslationTextComponent("messages.securitycraft:keycardReader.differentOwner");
        }
        if (te.getSignature() != tag.func_74762_e("signature")) {
            return new TranslationTextComponent("messages.securitycraft:keycardReader.wrongSignature");
        }
        int level = ((KeycardItem)stack.func_77973_b()).getLevel();
        if (!te.getAcceptedLevels()[level]) {
            return new TranslationTextComponent("messages.securitycraft:keycardReader.wrongLevel", new Object[]{level + 1});
        }
        boolean powered = (Boolean)world.func_180495_p(pos).func_177229_b((Property)POWERED);
        if (tag.func_74767_n("limited")) {
            int uses = tag.func_74762_e("uses");
            if (uses <= 0) {
                return new TranslationTextComponent("messages.securitycraft:keycardReader.noUses");
            }
            if (!player.func_184812_l_() && !powered) {
                tag.func_74768_a("uses", --uses);
            }
        }
        if (!powered) {
            KeycardReaderBlock.activate(world, pos, te.getSignalLength());
        }
        return null;
    }

    public static void activate(World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_195593_d(pos, (Block)SCContent.KEYCARD_READER.get());
        world.func_205220_G_().func_205360_a(pos, (Object)SCContent.KEYCARD_READER.get(), signalLength);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            world.func_195593_d(pos, (Block)SCContent.KEYCARD_READER.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeycardReaderTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

