/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReinforcedDoorBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public ReinforcedDoorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        boolean flag = (Boolean)state.func_177229_b((Property)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)FACING, facingState.func_177229_b((Property)FACING))).func_206870_a((Property)OPEN, facingState.func_177229_b((Property)OPEN))).func_206870_a(HINGE, facingState.func_177229_b(HINGE)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf;
        if (!world.field_72995_K && player.func_184812_l_() && (doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF)) == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((Property)OPEN);
            }
        }
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.onNeighborChanged(world, pos, fromPos);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        world.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext p_208073_1_) {
        boolean flag1;
        World iblockreader = p_208073_1_.func_195991_k();
        BlockPos blockpos = p_208073_1_.func_195995_a();
        Direction direction = p_208073_1_.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        Direction direction1 = direction.func_176735_f();
        BlockPos blockpos2 = blockpos.func_177972_a(direction1);
        BlockState blockstate = iblockreader.func_180495_p(blockpos2);
        BlockPos blockpos3 = blockpos1.func_177972_a(direction1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos3);
        Direction direction2 = direction.func_176746_e();
        BlockPos blockpos4 = blockpos.func_177972_a(direction2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos4);
        BlockPos blockpos5 = blockpos1.func_177972_a(direction2);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos5);
        int i = (blockstate.func_235785_r_((IBlockReader)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.func_235785_r_((IBlockReader)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.func_235785_r_((IBlockReader)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.func_235785_r_((IBlockReader)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.func_177230_c() == this && blockstate2.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vector3d vec3d = p_208073_1_.func_221532_j();
                double d0 = vec3d.field_72450_a - (double)blockpos.func_177958_n();
                double d1 = vec3d.field_72449_c - (double)blockpos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void onNeighborChanged(World world, BlockPos pos, BlockPos neighbor) {
        BlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        Owner previousOwner = null;
        if (world.func_175625_s(pos) instanceof OwnableTileEntity) {
            previousOwner = ((OwnableTileEntity)world.func_175625_s(pos)).getOwner();
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            BlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175655_b(pos, false);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = pos.func_177984_a();
            BlockState stateAbove = world.func_180495_p(blockAbove);
            if (stateAbove.func_177230_c() != this) {
                world.func_175655_b(pos, false);
                drop = true;
            }
            if (!BlockUtils.isSideSolid((IWorldReader)world, pos.func_177977_b(), Direction.UP)) {
                world.func_175655_b(pos, false);
                drop = true;
                if (stateAbove.func_177230_c() == this) {
                    world.func_175655_b(pos, false);
                }
            }
            if (drop) {
                if (!world.field_72995_K) {
                    world.func_175655_b(pos, false);
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)SCContent.REINFORCED_DOOR_ITEM.get()));
                }
            } else {
                boolean hasActiveSCBlock;
                boolean bl = hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, pos.func_177984_a());
                if (neighborBlock != this && hasActiveSCBlock != (Boolean)stateAbove.func_177229_b((Property)OPEN) && hasActiveSCBlock != (Boolean)state.func_177229_b((Property)OPEN)) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                    if (state.func_177229_b((Property)FACING) == Direction.WEST) {
                        BlockState secondDoorState = world.func_180495_p(pos.func_177978_c());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177978_c(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177968_d());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177968_d(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
                        BlockState secondDoorState = world.func_180495_p(pos.func_177974_f());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177974_f(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177976_e());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177976_e(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.func_177229_b((Property)FACING) == Direction.EAST) {
                        BlockState secondDoorState = world.func_180495_p(pos.func_177968_d());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177968_d(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177978_c());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177978_c(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
                        BlockState secondDoorState = world.func_180495_p(pos.func_177976_e());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177976_e(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177974_f());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.func_177229_b((Property)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177974_f(), (BlockState)secondDoorState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    }
                    world.func_217378_a((PlayerEntity)null, hasActiveSCBlock ? 1005 : 1011, pos, 0);
                }
            }
        }
        if (previousOwner != null && world.func_175625_s(pos) instanceof OwnableTileEntity && world.func_175625_s(pos.func_177984_a()) instanceof OwnableTileEntity) {
            ((OwnableTileEntity)world.func_175625_s(pos)).setOwner(previousOwner.getUUID(), previousOwner.getName());
            ((OwnableTileEntity)world.func_175625_s(pos.func_177984_a())).setOwner(previousOwner.getUUID(), previousOwner.getName());
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
        }
        return blockstate.func_177230_c() == this;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING))).func_235896_a_(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (state.func_177230_c() != newState.func_177230_c()) {
            world.func_175713_t(pos);
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)SCContent.REINFORCED_DOOR_ITEM.get());
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, FACING, OPEN, HINGE});
    }
}

