/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BulletEntity
extends AbstractArrowEntity {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(BulletEntity.class, Owner.getSerializer());
    private Collection<EffectInstance> potionEffects = Sets.newHashSet();

    public BulletEntity(EntityType<BulletEntity> type, World world) {
        super(SCContent.eTypeBullet, world);
    }

    public BulletEntity(World world, SentryEntity shooter) {
        super(SCContent.eTypeBullet, (LivingEntity)shooter, world);
        Owner owner = shooter.getOwner();
        this.potionEffects = shooter.func_70651_bq();
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.potionEffects.isEmpty()) {
            ListNBT list = new ListNBT();
            for (EffectInstance effect : this.potionEffects) {
                list.add((Object)effect.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("PotionEffects", (INBT)list);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        ListNBT potionList;
        super.func_70037_a(compound);
        if (compound.func_150297_b("PotionEffects", 9) && !(potionList = compound.func_150295_c("PotionEffects", 10)).isEmpty()) {
            for (int i = 0; i < potionList.size(); ++i) {
                EffectInstance effect = EffectInstance.func_82722_b((CompoundNBT)potionList.func_150305_b(i));
                if (effect == null) continue;
                this.potionEffects.add(effect);
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResult) {
        Entity target = raytraceResult.func_216348_a();
        if (!(target instanceof SentryEntity)) {
            target.func_70097_a(DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this.func_234616_v_()), (float)MathHelper.func_76143_f((double)this.func_213322_ci().func_72433_c()));
            if (target instanceof LivingEntity && !this.potionEffects.isEmpty()) {
                for (EffectInstance effect : this.potionEffects) {
                    ((LivingEntity)target).func_195064_c(effect);
                }
            }
            this.func_70106_y();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult raytraceResult) {
        this.func_70106_y();
    }

    protected void func_184548_a(LivingEntity entity) {
        this.func_70106_y();
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

