/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetCameraRotation;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SecurityCameraEntity
extends Entity {
    private final double CAMERA_SPEED;
    private double cameraUseX;
    private double cameraUseY;
    private double cameraUseZ;
    private float cameraUseYaw;
    private float cameraUsePitch;
    private int id;
    public int screenshotSoundCooldown;
    private int redstoneCooldown;
    private int toggleNightVisionCooldown;
    private int toggleLightCooldown;
    private boolean shouldProvideNightVision;
    private float zoomAmount;
    private boolean zooming;

    public SecurityCameraEntity(EntityType<SecurityCameraEntity> type, World world) {
        super(SCContent.eTypeSecurityCamera, world);
        this.CAMERA_SPEED = (Double)ConfigHandler.CLIENT.cameraSpeed.get();
        this.screenshotSoundCooldown = 0;
        this.redstoneCooldown = 0;
        this.toggleNightVisionCooldown = 0;
        this.toggleLightCooldown = 0;
        this.shouldProvideNightVision = false;
        this.zoomAmount = 1.0f;
        this.zooming = false;
        this.field_70145_X = true;
    }

    public SecurityCameraEntity(World world, double x, double y, double z, int id, PlayerEntity player) {
        this(SCContent.eTypeSecurityCamera, world);
        this.cameraUseX = player.func_226277_ct_();
        this.cameraUseY = player.func_226278_cu_();
        this.cameraUseZ = player.func_226281_cx_();
        this.cameraUseYaw = player.field_70177_z;
        this.cameraUsePitch = player.field_70125_A;
        this.id = id;
        this.func_70107_b(x + 0.5, y, z + 0.5);
        TileEntity te = world.func_175625_s(this.func_233580_cy_());
        if (te instanceof SecurityCameraTileEntity) {
            this.setInitialPitchYaw((SecurityCameraTileEntity)te);
        }
    }

    public SecurityCameraEntity(World world, double x, double y, double z, int id, SecurityCameraEntity camera) {
        this(SCContent.eTypeSecurityCamera, world);
        this.cameraUseX = camera.cameraUseX;
        this.cameraUseY = camera.cameraUseY;
        this.cameraUseZ = camera.cameraUseZ;
        this.cameraUseYaw = camera.cameraUseYaw;
        this.cameraUsePitch = camera.cameraUsePitch;
        this.id = id;
        this.func_70107_b(x + 0.5, y, z + 0.5);
        TileEntity te = world.func_175625_s(this.func_233580_cy_());
        if (te instanceof SecurityCameraTileEntity) {
            this.setInitialPitchYaw((SecurityCameraTileEntity)te);
        }
    }

    private void setInitialPitchYaw(SecurityCameraTileEntity te) {
        if (te != null && te.hasModule(ModuleType.SMART) && te.lastPitch != Float.MAX_VALUE && te.lastYaw != Float.MAX_VALUE) {
            this.field_70125_A = te.lastPitch;
            this.field_70177_z = te.lastYaw;
        } else {
            this.field_70125_A = 30.0f;
            Direction facing = (Direction)this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177229_b((Property)SecurityCameraBlock.FACING);
            if (facing == Direction.NORTH) {
                this.field_70177_z = 180.0f;
            } else if (facing == Direction.WEST) {
                this.field_70177_z = 90.0f;
            } else if (facing == Direction.SOUTH) {
                this.field_70177_z = 0.0f;
            } else if (facing == Direction.EAST) {
                this.field_70177_z = 270.0f;
            } else if (facing == Direction.DOWN) {
                this.field_70125_A = 75.0f;
            }
        }
    }

    public double func_70042_X() {
        return -0.75;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.func_184207_aI()) {
            PlayerEntity lowestEntity = (PlayerEntity)this.func_184188_bt().get(0);
            if (lowestEntity != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.toggleLightCooldown > 0) {
                --this.toggleLightCooldown;
            }
            if (lowestEntity.field_70177_z != this.field_70177_z) {
                lowestEntity.func_70080_a(lowestEntity.func_226277_ct_(), lowestEntity.func_226278_cu_(), lowestEntity.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
                lowestEntity.field_70177_z = this.field_70177_z;
            }
            if (lowestEntity.field_70125_A != this.field_70125_A) {
                lowestEntity.func_70080_a(lowestEntity.func_226277_ct_(), lowestEntity.func_226278_cu_(), lowestEntity.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            }
            this.checkKeysPressed();
            if (this.func_184188_bt().size() != 0 && this.shouldProvideNightVision) {
                SecurityCraft.channel.sendToServer((Object)new GiveNightVision());
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.func_184188_bt().size() != 0 && this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c() == SCContent.SECURITY_CAMERA.get())) {
            this.func_70106_y();
            return;
        }
    }

    private void checkKeysPressed() {
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            this.moveViewUp();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            this.moveViewDown();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            this.moveViewLeft();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            this.moveViewRight();
        }
        if (KeyBindings.cameraEmitRedstone.func_151468_f() && this.redstoneCooldown == 0) {
            this.setRedstonePower();
            this.redstoneCooldown = 30;
        }
        if (KeyBindings.cameraActivateNightVision.func_151468_f() && this.toggleNightVisionCooldown == 0) {
            this.enableNightVision();
        }
        if (KeyBindings.cameraZoomIn.func_151468_f()) {
            this.zoomIn();
            this.zooming = true;
        } else if (KeyBindings.cameraZoomOut.func_151468_f()) {
            this.zoomOut();
            this.zooming = true;
        } else {
            this.zooming = false;
        }
    }

    public void moveViewUp() {
        if (this.isCameraDown()) {
            if (this.field_70125_A > 40.0f) {
                this.field_70125_A = (float)((double)this.field_70125_A - this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else if (this.field_70125_A > -25.0f) {
            this.field_70125_A = (float)((double)this.field_70125_A - this.CAMERA_SPEED);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void moveViewDown() {
        if (this.isCameraDown()) {
            if (this.field_70125_A < 100.0f) {
                this.field_70125_A = (float)((double)this.field_70125_A + this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else if (this.field_70125_A < 60.0f) {
            this.field_70125_A = (float)((double)this.field_70125_A + this.CAMERA_SPEED);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void moveViewLeft() {
        BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        if (state.func_235901_b_((Property)SecurityCameraBlock.FACING)) {
            Direction facing = (Direction)state.func_177229_b((Property)SecurityCameraBlock.FACING);
            if (facing == Direction.EAST) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > -180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.WEST) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > 0.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.NORTH) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > 90.0 && (double)this.field_70177_z - this.CAMERA_SPEED < 185.0 || (double)this.field_70177_z - this.CAMERA_SPEED > -190.0 && (double)this.field_70177_z - this.CAMERA_SPEED < -90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.SOUTH) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > -90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.DOWN) {
                this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            this.updateServerRotation();
        }
    }

    public void moveViewRight() {
        BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        if (state.func_235901_b_((Property)SecurityCameraBlock.FACING)) {
            Direction facing = (Direction)state.func_177229_b((Property)SecurityCameraBlock.FACING);
            if (facing == Direction.EAST) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 0.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.WEST) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.NORTH) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED > 85.0 && (double)this.field_70177_z + this.CAMERA_SPEED < 185.0 || (double)this.field_70177_z + this.CAMERA_SPEED < -95.0 && (double)this.field_70177_z + this.CAMERA_SPEED > -180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.SOUTH) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == Direction.DOWN) {
                this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            this.updateServerRotation();
        }
    }

    public void zoomIn() {
        this.zoomAmount = Math.max(this.zoomAmount - 0.1f, 0.1f);
        if (!this.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(this.func_233580_cy_(), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void zoomOut() {
        this.zoomAmount = Math.min(this.zoomAmount + 0.1f, 1.5f);
        if (!this.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(this.func_233580_cy_(), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void setRedstonePower() {
        BlockPos pos = this.func_233580_cy_();
        if (((IModuleInventory)this.field_70170_p.func_175625_s(pos)).hasModule(ModuleType.REDSTONE)) {
            SecurityCraft.channel.sendToServer((Object)new SetCameraPowered(pos, (Boolean)this.field_70170_p.func_180495_p(pos).func_177229_b((Property)SecurityCameraBlock.POWERED) == false));
        }
    }

    public void enableNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    private void updateServerRotation() {
        SecurityCraft.channel.sendToServer((Object)new SetCameraRotation(this.field_70177_z, this.field_70125_A));
    }

    private boolean isCameraDown() {
        return this.field_70170_p.func_175625_s(this.func_233580_cy_()) instanceof SecurityCameraTileEntity && ((SecurityCameraTileEntity)this.field_70170_p.func_175625_s((BlockPos)this.func_233580_cy_())).down;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        livingEntity.field_70177_z = this.cameraUseYaw % 360.0f;
        livingEntity.field_70125_A = MathHelper.func_76131_a((float)this.cameraUsePitch, (float)-90.0f, (float)90.0f) % 360.0f;
        livingEntity.field_70126_B = livingEntity.field_70177_z;
        livingEntity.field_70127_C = livingEntity.field_70125_A;
        return this.getPreviousPlayerPos();
    }

    public Vector3d getPreviousPlayerPos() {
        return new Vector3d(this.cameraUseX, this.cameraUseY, this.cameraUseZ);
    }

    protected void func_70088_a() {
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a("CameraID", this.id);
        tag.func_74780_a("cameraUseX", this.cameraUseX);
        tag.func_74780_a("cameraUseY", this.cameraUseY);
        tag.func_74780_a("cameraUseZ", this.cameraUseZ);
        tag.func_74780_a("cameraUseYaw", (double)this.cameraUseYaw);
        tag.func_74780_a("cameraUsePitch", (double)this.cameraUsePitch);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.id = tag.func_74762_e("CameraID");
        this.cameraUseX = tag.func_74769_h("cameraUseX");
        this.cameraUseY = tag.func_74769_h("cameraUseY");
        this.cameraUseZ = tag.func_74769_h("cameraUseZ");
        this.cameraUseYaw = tag.func_74760_g("cameraUseYaw");
        this.cameraUsePitch = tag.func_74760_g("cameraUsePitch");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

