/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CameraView {
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public ResourceLocation dimension = World.field_234918_g_.func_240901_a_();

    public CameraView(int x, int y, int z, RegistryKey<World> dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (dim != null) {
            this.dimension = dim.func_240901_a_();
        }
    }

    public CameraView(int x, int y, int z, ResourceLocation dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (dim != null) {
            this.dimension = dim;
        }
    }

    public CameraView(BlockPos pos, RegistryKey<World> dim) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        if (dim != null) {
            this.dimension = dim.func_240901_a_();
        }
    }

    public BlockPos getLocation() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean checkCoordinates(String[] coordinates) {
        int xPos = Integer.parseInt(coordinates[0]);
        int yPos = Integer.parseInt(coordinates[1]);
        int zPos = Integer.parseInt(coordinates[2]);
        ResourceLocation dim = new ResourceLocation(coordinates.length == 4 ? coordinates[3] : "");
        return this.x == xPos && this.y == yPos && this.z == zPos && this.dimension.equals((Object)dim);
    }

    public String toNBTString() {
        return this.x + " " + this.y + " " + this.z + " " + this.dimension;
    }
}

