/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaySoundAtPos {
    private int x;
    private int y;
    private int z;
    private String sound;
    private double volume;
    private String category;

    public PlaySoundAtPos() {
    }

    public PlaySoundAtPos(int x, int y, int z, String sound, double volume, String cat) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.volume = volume;
        this.category = cat;
    }

    public PlaySoundAtPos(double x, double y, double z, String sound, double volume, String cat) {
        this((int)x, (int)y, (int)z, sound, volume, cat);
    }

    public static void encode(PlaySoundAtPos message, PacketBuffer buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.func_180714_a(message.sound);
        buf.writeDouble(message.volume);
        buf.func_180714_a(message.category);
    }

    public static PlaySoundAtPos decode(PacketBuffer buf) {
        PlaySoundAtPos message = new PlaySoundAtPos();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.sound = buf.func_150789_c(0x1FFFFFFF);
        message.volume = buf.readDouble();
        message.category = buf.func_150789_c(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(PlaySoundAtPos message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = SecurityCraft.proxy.getClientPlayer();
            BlockPos pos = player.func_233580_cy_();
            BlockPos origin = new BlockPos(message.x, message.y, message.z);
            int dist = Math.max(0, Math.min(pos.func_218139_n((Vector3i)origin), 20));
            float volume = (float)(message.volume * (double)(1.0f - (float)dist / 20.0f));
            Minecraft.func_71410_x().field_71441_e.func_184133_a(player, origin, new SoundEvent(new ResourceLocation(message.sound)), SoundCategory.valueOf((String)message.category.toUpperCase()), volume, 1.0f);
        });
        ctx.get().setPacketHandled(true);
    }
}

