/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class MountCamera {
    private BlockPos pos;
    private int id;

    public MountCamera() {
    }

    public MountCamera(BlockPos pos, int id) {
        this.pos = pos;
        this.id = id;
    }

    public static void encode(MountCamera message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeInt(message.id);
    }

    public static MountCamera decode(PacketBuffer buf) {
        MountCamera message = new MountCamera();
        message.pos = buf.func_179259_c();
        message.id = buf.readInt();
        return message;
    }

    public static void onMessage(MountCamera message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            BlockPos pos = message.pos;
            int id = message.id;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == SCContent.SECURITY_CAMERA.get() && (te = world.func_175625_s(pos)) instanceof SecurityCameraTileEntity && (((SecurityCameraTileEntity)te).getOwner().isOwner((PlayerEntity)player) || ((SecurityCameraTileEntity)te).hasModule(ModuleType.SMART))) {
                ((SecurityCameraBlock)state.func_177230_c()).mountCamera(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), id, (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

