/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.BlockPocketManagerTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncBlockPocketManager {
    private BlockPos pos;
    private int size;
    private boolean showOutline;
    private int autoBuildOffset;

    public SyncBlockPocketManager() {
    }

    public SyncBlockPocketManager(BlockPos pos, int size, boolean showOutline, int autoBuildOffset) {
        this.pos = pos;
        this.size = size;
        this.showOutline = showOutline;
        this.autoBuildOffset = autoBuildOffset;
    }

    public static void encode(SyncBlockPocketManager message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_150787_b(message.size);
        buf.writeBoolean(message.showOutline);
        buf.func_150787_b(message.autoBuildOffset);
    }

    public static SyncBlockPocketManager decode(PacketBuffer buf) {
        SyncBlockPocketManager message = new SyncBlockPocketManager();
        message.pos = buf.func_179259_c();
        message.size = buf.func_150792_a();
        message.showOutline = buf.readBoolean();
        message.autoBuildOffset = buf.func_150792_a();
        return message;
    }

    public static void onMessage(SyncBlockPocketManager message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            TileEntity te = world.func_175625_s(pos);
            if (world.func_195588_v(pos) && te instanceof BlockPocketManagerTileEntity && ((BlockPocketManagerTileEntity)te).getOwner().isOwner((PlayerEntity)player)) {
                BlockPocketManagerTileEntity bpm = (BlockPocketManagerTileEntity)te;
                BlockState state = world.func_180495_p(pos);
                bpm.size = message.size;
                bpm.showOutline = message.showOutline;
                bpm.autoBuildOffset = message.autoBuildOffset;
                world.func_184138_a(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

