/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.TrophySystemTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncTrophySystem {
    private BlockPos pos;
    private ResourceLocation projectileType;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityType<?> projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileType = projectileType.getRegistryName();
        this.allowed = allowed;
    }

    public static void encode(SyncTrophySystem message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_192572_a(message.projectileType);
        buf.writeBoolean(message.allowed);
    }

    public static SyncTrophySystem decode(PacketBuffer buf) {
        SyncTrophySystem message = new SyncTrophySystem();
        message.pos = buf.func_179259_c();
        message.projectileType = buf.func_192575_l();
        message.allowed = buf.readBoolean();
        return message;
    }

    public static void onMessage(SyncTrophySystem message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityType projectileType = (EntityType)ForgeRegistries.ENTITIES.getValue(message.projectileType);
            if (projectileType != null) {
                World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
                BlockPos pos = message.pos;
                boolean allowed = message.allowed;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TrophySystemTileEntity && ((TrophySystemTileEntity)te).getOwner().isOwner((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                    BlockState state = world.func_180495_p(pos);
                    ((TrophySystemTileEntity)te).setFilter(projectileType, allowed);
                    world.func_184138_a(pos, state, state, 2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

