/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorTileEntityRenderer
extends TileEntityRenderer<ProjectorTileEntity> {
    public ProjectorTileEntityRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(ProjectorTileEntity te, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, int combinedOverlay) {
        if (te.isActive() && !te.func_191420_l()) {
            Random random = new Random();
            BlockState state = te.getProjectedBlock().func_176223_P();
            RenderSystem.disableCull();
            for (int x = 0; x < te.getProjectionWidth(); ++x) {
                for (int y = 0; y < te.getProjectionHeight(); ++y) {
                    stack.func_227860_a_();
                    BlockPos pos = !te.isHorizontal() ? this.translateProjection(te.func_174877_v(), stack, (Direction)te.func_195044_w().func_177229_b((Property)ProjectorBlock.FACING), x, y, te.getProjectionRange(), te.getProjectionOffset()) : this.translateProjection(te.func_174877_v(), stack, (Direction)te.func_195044_w().func_177229_b((Property)ProjectorBlock.FACING), x, te.getProjectionRange() - 16, y + 1, te.getProjectionOffset());
                    if (pos != null && te.func_145831_w().func_175623_d(pos)) {
                        switch (state.func_185901_i()) {
                            case MODEL: {
                                for (RenderType rendertype : RenderType.func_228661_n_()) {
                                    if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)rendertype)) continue;
                                    Minecraft.func_71410_x().func_175602_ab().func_228793_a_(state, pos, (IBlockDisplayReader)te.func_145831_w(), stack, buffer.getBuffer(rendertype), true, random);
                                }
                                break;
                            }
                            case ENTITYBLOCK_ANIMATED: {
                                ItemStack tileEntityStack = new ItemStack((IItemProvider)state.func_177230_c());
                                tileEntityStack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(tileEntityStack, ItemCameraTransforms.TransformType.NONE, stack, buffer, packedLight, OverlayTexture.field_229196_a_);
                                break;
                            }
                        }
                    }
                    stack.func_227865_b_();
                }
            }
            RenderSystem.enableCull();
        }
    }

    private BlockPos translateProjection(BlockPos tePos, MatrixStack stack, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos = null;
        if (direction == Direction.NORTH) {
            pos = new BlockPos((double)(tePos.func_177958_n() + x) + offset, (double)(tePos.func_177956_o() + y), (double)tePos.func_177952_p() + distance);
            stack.func_227861_a_(0.0 + (double)x + offset, 0.0 + (double)y, distance);
        } else if (direction == Direction.SOUTH) {
            pos = new BlockPos((double)(tePos.func_177958_n() + x) + offset, (double)(tePos.func_177956_o() + y), (double)tePos.func_177952_p() + -distance);
            stack.func_227861_a_(0.0 + (double)x + offset, 0.0 + (double)y, -distance);
        } else if (direction == Direction.WEST) {
            pos = new BlockPos((double)tePos.func_177958_n() + distance, (double)(tePos.func_177956_o() + y), (double)(tePos.func_177952_p() + x) + offset);
            stack.func_227861_a_(distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        } else if (direction == Direction.EAST) {
            pos = new BlockPos((double)tePos.func_177958_n() + -distance, (double)(tePos.func_177956_o() + y), (double)(tePos.func_177952_p() + x) + offset);
            stack.func_227861_a_(-distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        }
        return pos;
    }

    public boolean isGlobalRenderer(ProjectorTileEntity te) {
        return true;
    }
}

