/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final TranslationTextComponent selectCameras = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]);
    private PlayerInventory playerInventory;
    private CameraMonitorItem cameraMonitor;
    private CompoundNBT nbtTag;
    private IdButton prevPageButton;
    private IdButton nextPageButton;
    private IdButton[] cameraButtons = new IdButton[10];
    private IdButton[] unbindButtons = new IdButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private SecurityCraftTileEntity[] cameraTEs = new SecurityCraftTileEntity[10];
    private ResourceLocation[] cameraViewDim = new ResourceLocation[10];
    private int xSize = 176;
    private int ySize = 166;
    private int page = 1;

    public CameraMonitorScreen(PlayerInventory inventory, CameraMonitorItem item, CompoundNBT itemNBTTag) {
        super((ITextComponent)new TranslationTextComponent(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a()));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(PlayerInventory inventory, CameraMonitorItem item, CompoundNBT itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void func_231160_c_() {
        int i;
        super.func_231160_c_();
        this.prevPageButton = new IdButton(-1, this.field_230708_k_ / 2 - 68, this.field_230709_l_ / 2 + 40, 20, 20, "<", this::actionPerformed);
        this.func_230480_a_((Widget)this.prevPageButton);
        this.nextPageButton = new IdButton(0, this.field_230708_k_ / 2 + 52, this.field_230709_l_ / 2 + 40, 20, 20, ">", this::actionPerformed);
        this.func_230480_a_((Widget)this.nextPageButton);
        this.cameraButtons[0] = new IdButton(1, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[1] = new IdButton(2, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[2] = new IdButton(3, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[3] = new IdButton(4, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[4] = new IdButton(5, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[5] = new IdButton(6, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[6] = new IdButton(7, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[7] = new IdButton(8, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[8] = new IdButton(9, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[9] = new IdButton(10, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 + 40, 80, 20, "", this::actionPerformed);
        this.unbindButtons[0] = new IdButton(11, this.field_230708_k_ / 2 - 19, this.field_230709_l_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[1] = new IdButton(12, this.field_230708_k_ / 2 + 11, this.field_230709_l_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[2] = new IdButton(13, this.field_230708_k_ / 2 + 41, this.field_230709_l_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[3] = new IdButton(14, this.field_230708_k_ / 2 - 19, this.field_230709_l_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[4] = new IdButton(15, this.field_230708_k_ / 2 + 11, this.field_230709_l_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[5] = new IdButton(16, this.field_230708_k_ / 2 + 41, this.field_230709_l_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[6] = new IdButton(17, this.field_230708_k_ / 2 - 19, this.field_230709_l_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[7] = new IdButton(18, this.field_230708_k_ / 2 + 11, this.field_230709_l_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[8] = new IdButton(19, this.field_230708_k_ / 2 + 41, this.field_230709_l_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[9] = new IdButton(20, this.field_230708_k_ / 2 + 41, this.field_230709_l_ / 2 + 32, 8, 8, "x", this::actionPerformed);
        for (i = 0; i < 10; ++i) {
            IdButton button = this.cameraButtons[i];
            int camID = button.id + (this.page - 1) * 10;
            ArrayList<CameraView> views = this.cameraMonitor.getCameraPositions(this.nbtTag);
            button.func_238482_a_((ITextComponent)button.func_230458_i_().func_230531_f_().func_230529_a_((ITextComponent)new StringTextComponent("" + camID)));
            this.func_230480_a_((Widget)button);
            CameraView view = views.get(camID - 1);
            if (view != null) {
                if (!view.dimension.equals((Object)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_())) {
                    this.hoverCheckers[button.id - 1] = new HoverChecker((Widget)button);
                    this.cameraViewDim[button.id - 1] = view.dimension;
                }
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                TileEntity te = world.func_175625_s(view.getLocation());
                if (world.func_180495_p(view.getLocation()).func_177230_c() != SCContent.SECURITY_CAMERA.get() || te instanceof SecurityCameraTileEntity && !((SecurityCameraTileEntity)te).getOwner().isOwner((PlayerEntity)Minecraft.func_71410_x().field_71439_g) && !((SecurityCameraTileEntity)te).hasModule(ModuleType.SMART)) {
                    button.field_230693_o_ = false;
                    this.cameraTEs[button.id - 1] = null;
                    continue;
                }
                this.cameraTEs[button.id - 1] = (SecurityCraftTileEntity)te;
                this.hoverCheckers[button.id - 1] = new HoverChecker((Widget)button);
                continue;
            }
            button.field_230693_o_ = false;
            this.unbindButtons[button.id - 1].field_230693_o_ = false;
            this.cameraTEs[button.id - 1] = null;
        }
        for (i = 0; i < 10; ++i) {
            this.func_230480_a_((Widget)this.unbindButtons[i]);
        }
        if (this.page == 1) {
            this.prevPageButton.field_230693_o_ = false;
        }
        if (this.page == 3 || this.cameraMonitor.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            this.nextPageButton.field_230693_o_ = false;
        }
        for (i = this.cameraMonitor.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].field_230693_o_ = false;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.selectCameras, (float)(startX + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.selectCameras) / 2), (float)(startY + 6), 0x404040);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (this.cameraTEs[i] == null) {
                this.func_238654_b_(matrix, this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("gui.securitycraft:monitor.cameraInDifferentDim", this.cameraViewDim[i]), 150), mouseX, mouseY);
            }
            if (this.cameraTEs[i] == null || !this.cameraTEs[i].hasCustomSCName()) continue;
            this.func_238654_b_(matrix, this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("gui.securitycraft:monitor.cameraName", this.cameraTEs[i].getCustomSCName()), 150), mouseX, mouseY);
        }
    }

    protected void actionPerformed(IdButton button) {
        if (button.id == this.prevPageButton.id) {
            this.field_230706_i_.func_147108_a((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1));
        } else if (button.id == this.nextPageButton.id) {
            this.field_230706_i_.func_147108_a((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1));
        } else if (button.id < 11) {
            int camID = button.id + (this.page - 1) * 10;
            CameraView view = this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1);
            Block block = Minecraft.func_71410_x().field_71441_e.func_180495_p(view.getLocation()).func_177230_c();
            if (block == SCContent.SECURITY_CAMERA.get()) {
                ((SecurityCameraBlock)block).mountCamera((World)Minecraft.func_71410_x().field_71441_e, view.x, view.y, view.z, camID, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                SecurityCraft.channel.sendToServer((Object)new MountCamera(view.getLocation(), camID));
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            } else {
                button.field_230693_o_ = false;
            }
        } else {
            int camID = button.id - 10 + (this.page - 1) * 10;
            SecurityCraft.channel.sendToServer((Object)new RemoveCameraTag(PlayerUtils.getSelectedItemStack(this.playerInventory, (Item)SCContent.CAMERA_MONITOR.get()), camID));
            this.nbtTag.func_82580_o(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1)));
            button.field_230693_o_ = false;
            this.cameraButtons[(camID - 1) % 10].field_230693_o_ = false;
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

