/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScrollPanel;

@OnlyIn(value=Dist.CLIENT)
public class EditModuleScreen
extends Screen {
    private static CompoundNBT savedModule;
    private static final ResourceLocation TEXTURE;
    private final TranslationTextComponent editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]);
    private ItemStack module = ItemStack.field_190927_a;
    private TextFieldWidget inputField;
    private IdButton addButton;
    private IdButton removeButton;
    private IdButton copyButton;
    private IdButton pasteButton;
    private IdButton clearButton;
    private int xSize = 247;
    private int ySize = 166;
    private PlayerList playerList;
    private int guiLeft;

    public EditModuleScreen(ItemStack item) {
        super((ITextComponent)new TranslationTextComponent(item.func_77977_a()));
        this.module = item;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        int controlsStartX = (int)((float)this.guiLeft + (float)this.xSize * 0.75f) - 43;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.inputField = new TextFieldWidget(this.field_230712_o_, controlsStartX - 17, this.field_230709_l_ / 2 - 65, 110, 15, StringTextComponent.field_240750_d_);
        this.func_230480_a_((Widget)this.inputField);
        this.addButton = new IdButton(0, controlsStartX, this.field_230709_l_ / 2 - 45, 76, 20, (ITextComponent)Utils.localize("gui.securitycraft:editModule.add", new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.addButton);
        this.removeButton = new IdButton(1, controlsStartX, this.field_230709_l_ / 2 - 20, 76, 20, (ITextComponent)Utils.localize("gui.securitycraft:editModule.remove", new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.removeButton);
        this.copyButton = new IdButton(2, controlsStartX, this.field_230709_l_ / 2 + 5, 76, 20, (ITextComponent)Utils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.copyButton);
        this.pasteButton = new IdButton(3, controlsStartX, this.field_230709_l_ / 2 + 30, 76, 20, (ITextComponent)Utils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.pasteButton);
        this.clearButton = new IdButton(4, controlsStartX, this.field_230709_l_ / 2 + 55, 76, 20, (ITextComponent)Utils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.clearButton);
        this.func_230480_a_((Widget)this.clearButton);
        this.playerList = new PlayerList(this.field_230706_i_, 110, 141, this.field_230709_l_ / 2 - 66, this.guiLeft + 10);
        this.field_230705_e_.add(this.playerList);
        this.addButton.field_230693_o_ = false;
        this.removeButton.field_230693_o_ = false;
        if (this.module.func_77978_p() == null || this.module.func_77978_p().isEmpty() || this.module.func_77978_p() != null && this.module.func_77978_p().equals((Object)savedModule)) {
            this.copyButton.field_230693_o_ = false;
        }
        if (savedModule == null || savedModule.isEmpty() || this.module.func_77978_p() != null && this.module.func_77978_p().equals((Object)savedModule)) {
            this.pasteButton.field_230693_o_ = false;
        }
        if (this.module.func_77978_p() == null || this.module.func_77978_p().isEmpty()) {
            this.clearButton.field_230693_o_ = false;
        }
        this.inputField.func_146203_f(16);
        this.inputField.func_200675_a(s -> !s.contains(" "));
        this.inputField.func_212954_a(s -> {
            if (s.isEmpty()) {
                this.addButton.field_230693_o_ = false;
            } else {
                if (this.module.func_77942_o()) {
                    for (int i = 1; i <= 50; ++i) {
                        if (!s.equals(this.module.func_77978_p().func_74779_i("Player" + i))) continue;
                        this.addButton.field_230693_o_ = false;
                        this.removeButton.field_230693_o_ = true;
                        this.playerList.setSelectedIndex(i - 1);
                        return;
                    }
                }
                this.addButton.field_230693_o_ = true;
            }
            this.removeButton.field_230693_o_ = false;
            this.playerList.setSelectedIndex(-1);
        });
        this.func_212928_a((IGuiEventListener)this.inputField);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.field_230706_i_ != null) {
            this.field_230706_i_.field_195559_v.func_197967_a(false);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_238418_a_((ITextProperties)this.editModule, startX + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.editModule) / 2, startY + 6, this.field_230708_k_, 0x404040);
        if (this.playerList != null) {
            this.playerList.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (this.playerList != null && this.playerList.func_231047_b_(mouseX, mouseY)) {
            this.playerList.func_231043_a_(mouseX, mouseY, scroll);
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.func_231044_a_(mouseX, mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.playerList != null) {
            this.playerList.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void actionPerformed(IdButton button) {
        if (button.id == this.addButton.id) {
            if (this.inputField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.module.func_77978_p() == null) {
                this.module.func_77982_d(new CompoundNBT());
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                if (i == 9) {
                    this.addButton.field_230693_o_ = false;
                }
                return;
            }
            this.module.func_77978_p().func_74778_a("Player" + this.getNextFreeSlot(this.module.func_77978_p()), this.inputField.func_146179_b());
            if (this.module.func_77978_p() != null && this.module.func_77978_p().func_74764_b("Player50")) {
                this.addButton.field_230693_o_ = false;
            }
            this.inputField.func_146180_a("");
        } else if (button.id == this.removeButton.id) {
            if (this.inputField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.module.func_77978_p() == null) {
                this.module.func_77982_d(new CompoundNBT());
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                this.module.func_77978_p().func_82580_o("Player" + i);
                this.defragmentTag(this.module.func_77978_p());
            }
            this.inputField.func_146180_a("");
        } else {
            if (button.id == this.copyButton.id) {
                savedModule = this.module.func_77978_p().func_74737_b();
                this.copyButton.field_230693_o_ = false;
                return;
            }
            if (button.id == this.pasteButton.id) {
                this.module.func_77982_d(savedModule.func_74737_b());
            } else if (button.id == this.clearButton.id) {
                this.module.func_77982_d(new CompoundNBT());
                this.inputField.func_146180_a("");
            } else {
                return;
            }
        }
        if (this.module.func_77978_p() != null) {
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(this.module));
        }
        this.addButton.field_230693_o_ = this.module.func_77978_p() != null && !this.module.func_77978_p().func_74764_b("Player50") && !this.inputField.func_146179_b().isEmpty();
        this.removeButton.field_230693_o_ = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty() && !this.inputField.func_146179_b().isEmpty();
        this.copyButton.field_230693_o_ = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty() && (this.module.func_77978_p() == null || !this.module.func_77978_p().equals((Object)savedModule));
        this.pasteButton.field_230693_o_ = savedModule != null && !savedModule.isEmpty() && (this.module.func_77978_p() == null || !this.module.func_77978_p().equals((Object)savedModule));
        this.clearButton.field_230693_o_ = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty();
    }

    private int getNextFreeSlot(CompoundNBT tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.func_74764_b("Player" + i) && !tag.func_74779_i("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private void defragmentTag(CompoundNBT tag) {
        ArrayDeque<Integer> freeIndices = new ArrayDeque<Integer>();
        for (int i = 1; i <= 50; ++i) {
            if (!tag.func_74764_b("Player" + i) || tag.func_74779_i("Player" + i).isEmpty()) {
                freeIndices.add(i);
                continue;
            }
            if (freeIndices.isEmpty()) continue;
            String player = tag.func_74779_i("Player" + i);
            int nextFreeIndex = (Integer)freeIndices.poll();
            tag.func_74778_a("Player" + nextFreeIndex, player);
            tag.func_82580_o("Player" + i);
            freeIndices.add(i);
        }
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/edit_module.png");
    }

    class PlayerList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength = 50;
        private int selectedIndex;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = 50;
            this.selectedIndex = -1;
        }

        protected int getContentHeight() {
            EditModuleScreen.this.field_230712_o_.getClass();
            int height = 50 + 50 * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < (double)(this.left + this.width - 6)) {
                int clickedIndex = (int)(mouseY - (double)this.top + (double)this.scrollDistance - 4.0) / 12;
                if (EditModuleScreen.this.module.func_77942_o() && EditModuleScreen.this.module.func_77978_p().func_74764_b("Player" + (clickedIndex + 1))) {
                    this.selectedIndex = clickedIndex;
                    EditModuleScreen.this.inputField.func_146180_a(EditModuleScreen.this.module.func_77978_p().func_74779_i("Player" + (clickedIndex + 1)));
                }
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        protected void drawPanel(MatrixStack matrix, int entryRight, int relativeY, Tessellator tessellator, int mouseX, int mouseY) {
            if (EditModuleScreen.this.module.func_77942_o()) {
                CompoundNBT tag = EditModuleScreen.this.module.func_77978_p();
                int baseY = this.top + 4 - (int)this.scrollDistance;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f);
                int slotIndex = mouseListY / 12;
                if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 50 && mouseY >= this.top && mouseY <= this.bottom && tag.func_74764_b("Player" + (slotIndex + 1)) && !tag.func_74779_i("Player" + (slotIndex + 1)).isEmpty()) {
                    this.renderBox(tessellator.func_178180_c(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
                }
                if (this.selectedIndex >= 0) {
                    this.renderBox(tessellator.func_178180_c(), this.left, entryRight - 6, baseY + this.selectedIndex * 12, 8, 255);
                }
                for (int i = 0; i < 50; ++i) {
                    String name;
                    if (!tag.func_74764_b("Player" + (i + 1)) || (name = tag.func_74779_i("Player" + (i + 1))).isEmpty()) continue;
                    EditModuleScreen.this.field_230712_o_.func_238421_b_(matrix, name, (float)(this.left - 2 + this.width / 2 - EditModuleScreen.this.field_230712_o_.func_78256_a(name) / 2), (float)(relativeY + 12 * i), 0xC6C6C6);
                }
            }
        }

        private void renderBox(BufferBuilder bufferBuilder, int min, int max, int slotTop, int slotBuffer, int borderColor) {
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.defaultBlendFunc();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_225582_a_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(borderColor, borderColor, borderColor, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(borderColor, borderColor, borderColor, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)max, (double)(slotTop - 2), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(borderColor, borderColor, borderColor, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)min, (double)(slotTop - 2), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(borderColor, borderColor, borderColor, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)(max - 1), (double)(slotTop - 1), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_225582_a_((double)(min + 1), (double)(slotTop - 1), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }
    }
}

