/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ClientUtils {
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/item/module_background.png"), new ResourceLocation("securitycraft", "textures/item/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/item/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/item/harming_module.png"), new ResourceLocation("securitycraft", "textures/item/smart_module.png"), new ResourceLocation("securitycraft", "textures/item/storage_module.png"), new ResourceLocation("securitycraft", "textures/item/disguise_module.png"), new ResourceLocation("securitycraft", "textures/item/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/item/redstone.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/item/sugar.png");

    public static String getFormattedMinecraftTime() {
        Long time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    public static void syncItemNBT(ItemStack item) {
        SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(item));
    }

    public static void renderModuleInfo(MatrixStack matrix, ModuleType module, ITextComponent moduleTooltip, ITextComponent noModuleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        Matrix4f m4f = matrix.func_227866_c_().func_227870_a_();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.defaultBlendFunc();
        mc.func_110434_K().func_110577_a(MODULE_TEXTURES[module.ordinal()]);
        ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            mc.func_110434_K().func_110577_a(REDSTONE_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            mc.func_110434_K().func_110577_a(SUGAR_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        RenderSystem.disableBlend();
        if (mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            ITextComponent text;
            ITextComponent iTextComponent = text = isModuleInstalled ? moduleTooltip : noModuleTooltip;
            if (text != null) {
                GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(text), (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)mc.field_71466_p);
            }
        }
    }

    private static void drawTexture(BufferBuilder bufferBuilder, Matrix4f m4f, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferBuilder.func_227888_a_(m4f, (float)moduleLeft, (float)moduleBottom, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m4f, (float)moduleRight, (float)moduleBottom, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m4f, (float)moduleRight, (float)moduleTop, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m4f, (float)moduleLeft, (float)moduleTop, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }
}

