/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class CombinedModelData
implements IModelData {
    private final List<IModelData> subDatas;

    public static IModelData combine(IModelData ... datas) {
        ArrayList<IModelData> subDataList = new ArrayList<IModelData>(datas.length);
        for (IModelData inputData : datas) {
            if (inputData instanceof EmptyModelData) continue;
            if (inputData instanceof CombinedModelData) {
                subDataList.addAll(((CombinedModelData)inputData).subDatas);
                continue;
            }
            subDataList.add(inputData);
        }
        if (subDataList.isEmpty()) {
            return EmptyModelData.INSTANCE;
        }
        if (subDataList.size() == 1) {
            return (IModelData)subDataList.get(0);
        }
        return new CombinedModelData(subDataList);
    }

    private CombinedModelData(List<IModelData> subDatas) {
        this.subDatas = subDatas;
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        for (IModelData d : this.subDatas) {
            if (!d.hasProperty(prop)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T2> T2 getData(ModelProperty<T2> prop) {
        for (IModelData d : this.subDatas) {
            if (!d.hasProperty(prop)) continue;
            return (T2)d.getData(prop);
        }
        return null;
    }

    @Nullable
    public <T2> T2 setData(ModelProperty<T2> prop, T2 data) {
        return null;
    }
}

