/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public final class ConnectionPoint
implements Comparable<ConnectionPoint> {
    @Nonnull
    private final BlockPos pos;
    private final int index;

    public ConnectionPoint(@Nonnull BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
    }

    public ConnectionPoint(CompoundNBT nbt) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt);
        this.index = nbt.func_74762_e("index");
    }

    public CompoundNBT createTag() {
        CompoundNBT ret = NBTUtil.func_186859_a((BlockPos)this.pos);
        ret.func_74768_a("index", this.index);
        return ret;
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.pos;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoint that = (ConnectionPoint)o;
        if (this.index != that.index) {
            return false;
        }
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public int compareTo(ConnectionPoint o) {
        int blockCmp = this.pos.compareTo((Vector3i)o.pos);
        if (blockCmp != 0) {
            return blockCmp;
        }
        return Integer.compare(this.index, o.index);
    }

    public String toString() {
        return "[x=" + this.pos.func_177958_n() + ", y=" + this.pos.func_177956_o() + ", z=" + this.pos.func_177952_p() + ", index=" + this.index + "]";
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }
}

