/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateWorld;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ManualElementMultiblock
extends SpecialManualElements {
    private final MultiblockHandler.IMultiblock multiblock;
    private boolean canTick = true;
    private boolean showCompleted = false;
    private float scale = 50.0f;
    private float transX = 0.0f;
    private float transY = 0.0f;
    private TransformationMatrix additionalTransform;
    private List<ITextComponent> componentTooltip;
    private final MultiblockRenderInfo renderInfo;
    private final TemplateWorld structureWorld;
    private final int yOffTotal;
    private long lastStep = -1L;
    private long lastPrintedErrorTimeMs = -1L;
    private static final ITextComponent greenTick = TextUtils.applyFormat((ITextComponent)new StringTextComponent("\u2713"), TextFormatting.GREEN, TextFormatting.BOLD).func_240702_b_(" ");

    public ManualElementMultiblock(ManualInstance manual, MultiblockHandler.IMultiblock multiblock) {
        super(manual);
        this.multiblock = multiblock;
        List<Template.BlockInfo> structure = multiblock.getStructure((World)Minecraft.func_71410_x().field_71441_e);
        this.renderInfo = new MultiblockRenderInfo(structure);
        float diagLength = (float)Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength);
        this.structureWorld = new TemplateWorld(structure, this.renderInfo);
        this.transX = 60.0f + (float)this.renderInfo.structureWidth / 2.0f;
        this.transY = 35.0f + diagLength / 2.0f;
        this.additionalTransform = new TransformationMatrix(null, new Quaternion(25.0f, 0.0f, 0.0f, true), null, new Quaternion(0.0f, -45.0f, 0.0f, true));
        this.scale = multiblock.getManualScale();
        this.yOffTotal = (int)(this.transY + this.scale * diagLength / 2.0f);
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        int yOff = 0;
        if (this.multiblock.getStructure(null) != null) {
            boolean canRenderFormed = this.multiblock.canRenderFormedStructure();
            yOff = (int)((double)this.transY + (double)this.scale * Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0);
            pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, (int)this.transY - (canRenderFormed ? 11 : 5), 10, 10, 4, btn -> {
                GuiButtonManualNavigation btnNav = (GuiButtonManualNavigation)btn;
                this.canTick = !this.canTick;
                this.lastStep = -1L;
                btnNav.type = btnNav.type == 4 ? 5 : 4;
            }));
            if (this.renderInfo.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, (int)this.transY - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3, btn -> this.renderInfo.setShowLayer(Math.min(this.renderInfo.showLayer + 1, this.renderInfo.structureHeight - 1))));
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, (int)this.transY + (canRenderFormed ? 14 : 8), 10, 16, 2, btn -> this.renderInfo.setShowLayer(Math.max(this.renderInfo.showLayer - 1, -1))));
            }
            if (canRenderFormed) {
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, (int)this.transY + 1, 10, 10, 6, btn -> {
                    this.showCompleted = !this.showCompleted;
                }));
            }
        }
        this.checkMaterials();
        super.onOpened(gui, x, yOff, pageButtons);
    }

    private void checkMaterials() {
        ItemStack[] totalMaterials = this.multiblock.getTotalMaterials();
        if (totalMaterials != null) {
            ItemStack req;
            int ss;
            this.componentTooltip = new ArrayList<ITextComponent>();
            this.componentTooltip.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.reqMaterial"));
            int maxOff = 1;
            boolean hasAnyItems = false;
            boolean[] hasItems = new boolean[totalMaterials.length];
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                ItemStack inSlot;
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int reqSize = req.func_190916_E();
                for (int slot = 0; slot < ManualUtils.mc().field_71439_g.field_71071_by.func_70302_i_() && ((inSlot = ManualUtils.mc().field_71439_g.field_71071_by.func_70301_a(slot)).func_190926_b() || !ItemStack.func_179545_c((ItemStack)inSlot, (ItemStack)req) || (reqSize -= inSlot.func_190916_E()) > 0); ++slot) {
                }
                if (reqSize <= 0) {
                    hasItems[ss] = true;
                    if (!hasAnyItems) {
                        hasAnyItems = true;
                    }
                }
                maxOff = Math.max(maxOff, ("" + req.func_190916_E()).length());
            }
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int indent = maxOff - ("" + req.func_190916_E()).length();
                StringBuilder sIndent = new StringBuilder();
                if (indent > 0) {
                    for (int ii = 0; ii < indent; ++ii) {
                        sIndent.append("0");
                    }
                }
                Object s = hasItems[ss] ? greenTick.func_230532_e_() : new StringTextComponent(hasAnyItems ? "   " : "");
                s.func_230529_a_((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent(sIndent.toString() + req.func_190916_E() + "x "), TextFormatting.GRAY));
                if (!req.func_190926_b()) {
                    s.func_230529_a_((ITextComponent)TextUtils.applyFormat((ITextComponent)req.func_200301_q().func_230532_e_(), req.func_77953_t().field_77937_e));
                } else {
                    s.func_240702_b_("???");
                }
                this.componentTooltip.add((ITextComponent)s);
            }
        }
    }

    @Override
    public void render(MatrixStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        if (this.multiblock.getStructure(null) != null) {
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            MatrixStack.Entry lastEntryBeforeTry = transform.func_227866_c_();
            try {
                long currentTime = System.currentTimeMillis();
                if (this.lastStep < 0L) {
                    this.lastStep = currentTime;
                } else if (this.canTick && currentTime - this.lastStep > 500L) {
                    this.renderInfo.step();
                    this.lastStep = currentTime;
                }
                int structureLength = this.renderInfo.structureLength;
                int structureWidth = this.renderInfo.structureWidth;
                int structureHeight = this.renderInfo.structureHeight;
                transform.func_227860_a_();
                BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
                transform.func_227861_a_((double)this.transX, (double)this.transY, (double)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
                transform.func_227862_a_(this.scale, -this.scale, 1.0f);
                this.additionalTransform.push(transform);
                transform.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                transform.func_227861_a_((double)((float)structureLength / -2.0f), (double)((float)structureHeight / -2.0f), (double)((float)structureWidth / -2.0f));
                int idx = 0;
                if (this.showCompleted && this.multiblock.canRenderFormedStructure()) {
                    transform.func_227860_a_();
                    this.multiblock.renderFormedStructure(transform, IERenderTypes.disableLighting((IRenderTypeBuffer)buffer));
                    transform.func_227865_b_();
                } else {
                    for (int h = 0; h < structureHeight; ++h) {
                        for (int l = 0; l < structureLength; ++l) {
                            for (int w = 0; w < structureWidth; ++w) {
                                BlockPos pos = new BlockPos(l, h, w);
                                BlockState state = this.structureWorld.func_180495_p(pos);
                                if (state.isAir((IBlockReader)this.structureWorld, pos)) continue;
                                transform.func_227860_a_();
                                transform.func_227861_a_((double)l, (double)h, (double)w);
                                boolean b = this.multiblock.overwriteBlockRender(state, idx++);
                                if (!b) {
                                    int overlay = pos.equals((Object)this.multiblock.getTriggerOffset()) ? OverlayTexture.func_229200_a_((float)0.0f, (boolean)true) : OverlayTexture.field_229196_a_;
                                    EmptyModelData modelData = EmptyModelData.INSTANCE;
                                    TileEntity te = this.structureWorld.func_175625_s(pos);
                                    if (te != null) {
                                        modelData = te.getModelData();
                                    }
                                    blockRender.renderBlock(state, transform, IERenderTypes.disableLighting((IRenderTypeBuffer)buffer), 0xF000F0, overlay, (IModelData)modelData);
                                }
                                transform.func_227865_b_();
                            }
                        }
                    }
                }
                transform.func_227865_b_();
                transform.func_227865_b_();
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastPrintedErrorTimeMs + 1000L) {
                    e.printStackTrace();
                    this.lastPrintedErrorTimeMs = now;
                }
                while (lastEntryBeforeTry != transform.func_227866_c_()) {
                    transform.func_227865_b_();
                }
            }
            buffer.func_228461_a_();
            if (this.componentTooltip != null) {
                this.manual.fontRenderer().func_238421_b_(transform, "?", 116.0f, (float)(this.yOffTotal / 2 - 4), this.manual.getTextColour());
                if (mouseX >= 116 && mouseX < 122 && mouseY >= this.yOffTotal / 2 - 4 && mouseY < this.yOffTotal / 2 + 4) {
                    gui.renderToolTip(transform, LanguageMap.func_74808_a().func_244260_a(Collections.unmodifiableList(this.componentTooltip)), mouseX, mouseY, this.manual.fontRenderer());
                }
            }
        }
    }

    @Override
    public void mouseDragged(int x, int y, double clickX, double clickY, double mouseX, double mouseY, double lastX, double lastY, int mouseButton) {
        if (clickX >= 40.0 && clickX < 144.0 && mouseX >= 20.0 && mouseX < 164.0 && clickY >= 30.0 && clickY < 130.0 && mouseY >= 30.0 && mouseY < 180.0) {
            double dx = mouseX - lastX;
            double dy = mouseY - lastY;
            this.additionalTransform = ClientUtils.composeFixed(this.forRotation(dx * 80.0 / 104.0, dy * 0.8), this.additionalTransform);
        }
    }

    private TransformationMatrix forRotation(double rX, double rY) {
        Vector3f axis = new Vector3f((float)rY, (float)rX, 0.0f);
        float angle = (float)Math.sqrt(axis.func_195903_b(axis));
        if (!axis.func_229194_d_()) {
            return TransformationMatrix.func_227983_a_();
        }
        return new TransformationMatrix(null, new Quaternion(axis, angle, true), null, null);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.yOffTotal;
    }

    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    static class MultiblockRenderInfo
    implements Predicate<BlockPos> {
        public Map<BlockPos, Template.BlockInfo> data = new HashMap<BlockPos, Template.BlockInfo>();
        private final int structureHeight;
        private final int structureLength;
        private final int structureWidth;
        private final int maxBlockIndex;
        private int showLayer = -1;
        private int blockIndex;

        MultiblockRenderInfo(List<Template.BlockInfo> structure) {
            int structureHeight = 0;
            int structureWidth = 0;
            int structureLength = 0;
            for (Template.BlockInfo block : structure) {
                structureHeight = Math.max(structureHeight, block.field_186242_a.func_177956_o() + 1);
                structureWidth = Math.max(structureWidth, block.field_186242_a.func_177952_p() + 1);
                structureLength = Math.max(structureLength, block.field_186242_a.func_177958_n() + 1);
                this.data.put(block.field_186242_a, block);
            }
            this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
            this.structureHeight = structureHeight;
            this.structureLength = structureLength;
            this.structureWidth = structureWidth;
        }

        void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int y = index / (this.structureLength * this.structureWidth);
            int z = r % this.structureWidth;
            return !this.data.containsKey(new BlockPos(x, y, z));
        }

        int getLimiter() {
            return this.blockIndex;
        }

        @Override
        public boolean test(BlockPos blockPos) {
            int index = blockPos.func_177952_p() + this.structureWidth * (blockPos.func_177958_n() + this.structureLength * blockPos.func_177956_o());
            return index <= this.getLimiter();
        }
    }
}

