/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.TileRenderUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AutoWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class AutoWorkbenchRenderer
extends TileEntityRenderer<AutoWorkbenchTileEntity> {
    public static DynamicModel<Direction> DYNAMIC;
    public static HashMap<BlueprintCraftingRecipe, BlueprintLines> blueprintCache;

    public AutoWorkbenchRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(AutoWorkbenchTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float tx;
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.getWorldNonnull().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.autoWorkbench) {
            return;
        }
        IBakedModel model = DYNAMIC.get(te.getFacing());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        bufferIn = TileRenderUtils.mirror(te, matrixStack, bufferIn);
        float[][] itemDisplays = new float[te.processQueue.size()][];
        float drill = 0.0f;
        float lift = 0.0f;
        float press = 0.0f;
        float liftPress = 0.0f;
        for (int i = 0; i < itemDisplays.length; ++i) {
            float processTimer;
            PoweredMultiblockTileEntity.MultiblockProcess process = (PoweredMultiblockTileEntity.MultiblockProcess)te.processQueue.get(i);
            if (process == null || process.processTick <= 0 || process.processTick == process.maxTicks || (processTimer = (float)process.processTick / (float)process.maxTicks * 180.0f) <= 9.0f) continue;
            float itemX = -1.0f;
            float itemY = -0.34375f;
            float itemZ = -0.9375f;
            float itemAngle = 90.0f;
            if (processTimer <= 24.0f) {
                itemAngle = 67.5f;
                if (processTimer <= 19.0f) {
                    itemZ = (float)((double)itemZ + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.5f)));
                    itemY = (float)((double)itemY + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.21875f)));
                } else {
                    itemZ += (24.0f - processTimer) / 5.0f * 0.25f;
                    itemY += (24.0f - processTimer) / 5.0f * 0.25f;
                }
            } else if (processTimer <= 40.0f) {
                itemX += (processTimer - 24.0f) / 16.0f;
            } else if (processTimer <= 100.0f) {
                itemX += 1.0f;
                float drillStep = 0.0f;
                if (processTimer <= 60.0f) {
                    lift = (processTimer - 40.0f) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (60.0f - processTimer) * 4.0f;
                } else if (processTimer <= 80.0f) {
                    lift = 0.3125f;
                    drillStep = 4.0f;
                } else {
                    lift = (100.0f - processTimer) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (processTimer - 80.0f) * 4.0f;
                }
                if (drillStep > 0.0f) {
                    drill = processTimer % drillStep / drillStep * 360.0f;
                }
                itemY = (float)((double)itemY + Math.max(0.0, (double)lift - 0.0625));
            } else if (processTimer <= 116.0f) {
                itemX += 1.0f;
                itemZ += (processTimer - 100.0f) / 16.0f;
            } else if (processTimer <= 132.0f) {
                itemX += 1.0f + (processTimer - 116.0f) / 16.0f;
                itemZ += 1.0f;
            } else if (processTimer <= 172.0f) {
                itemX += 2.0f;
                itemZ += 1.0f;
                press = processTimer <= 142.0f ? (processTimer - 132.0f) / 10.0f : (processTimer <= 162.0f ? 1.0f : (172.0f - processTimer) / 10.0f);
                liftPress = press * 0.0625f;
                itemY += liftPress;
            } else if (processTimer <= 180.0f) {
                itemX += 2.0f + (processTimer - 172.0f) / 16.0f;
                itemZ += 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemAngle};
        }
        matrixStack.func_227860_a_();
        ItemStack blueprintStack = (ItemStack)te.inventory.get(0);
        if (!blueprintStack.func_190926_b()) {
            AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, te.getWorldNonnull(), state, model, blockPos, "blueprint");
        }
        matrixStack.func_227861_a_(0.0, (double)lift, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, te.getWorldNonnull(), state, model, blockPos, "lift");
        matrixStack.func_227861_a_(0.0, (double)(-lift), 0.0);
        Direction f = te.getFacing();
        float f2 = f == Direction.WEST ? -0.9375f : (tx = f == Direction.EAST ? 0.9375f : 0.0f);
        float tz = f == Direction.NORTH ? -0.9375f : (f == Direction.SOUTH ? 0.9375f : 0.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)tx, 0.0, (double)tz);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), drill, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, te.getWorldNonnull(), state, model, blockPos, "drill");
        matrixStack.func_227865_b_();
        float f3 = f == Direction.WEST ? -0.59375f : (tx = f == Direction.EAST ? 0.59375f : 0.0f);
        tz = f == Direction.NORTH ? -0.59375f : (f == Direction.SOUTH ? 0.59375f : 0.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)tx, -0.21875, (double)tz);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f((float)(-f.func_82599_e()), 0.0f, (float)f.func_82601_c()), press * 90.0f, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, te.getWorldNonnull(), state, model, blockPos, "press");
        matrixStack.func_227865_b_();
        matrixStack.func_227861_a_(0.0, (double)liftPress, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, te.getWorldNonnull(), state, model, blockPos, "pressLift");
        matrixStack.func_227861_a_(0.0, (double)(-liftPress), 0.0);
        matrixStack.func_227865_b_();
        switch (f) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true));
            }
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            PoweredMultiblockTileEntity.MultiblockProcess process;
            if (itemDisplays[i] == null || !((process = (PoweredMultiblockTileEntity.MultiblockProcess)te.processQueue.get(i)) instanceof PoweredMultiblockTileEntity.MultiblockProcessInWorld)) continue;
            float scale = 0.3125f;
            List<ItemStack> dList = ((PoweredMultiblockTileEntity.MultiblockProcessInWorld)process).getDisplayItem();
            if (dList.isEmpty()) continue;
            if (dList.size() < 2) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)itemDisplays[i][1], (double)itemDisplays[i][2], (double)itemDisplays[i][3]);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), itemDisplays[i][4], true));
                matrixStack.func_227862_a_(scale, scale, 0.5f);
                ClientUtils.mc().func_175599_af().func_229110_a_(dList.get(0), ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
                matrixStack.func_227865_b_();
                continue;
            }
            int size = dList.size();
            int lines = (int)Math.ceil((float)size / 2.0f);
            float spacer = (float)(lines - 1) * 0.234375f;
            for (int d = 0; d < size; ++d) {
                float oX = (size > 2 ? -0.3125f : 0.0f) + (float)(lines - d / 2) * 0.0625f + (float)(d % 2) * 0.3125f;
                float oZ = -spacer / 2.0f + (float)(d / 2) * 0.234375f;
                float oY = 0.0f;
                float localItemX = itemDisplays[i][1] + oX;
                float localItemY = itemDisplays[i][2] + oY;
                float localItemZ = itemDisplays[i][3] + oZ;
                float subProcess = itemDisplays[i][0] - (float)(d / 2 * 4);
                float localAngle = itemDisplays[i][4];
                if (subProcess <= 24.0f) {
                    localAngle = 67.5f;
                    if (subProcess <= 19.0f) {
                        localItemZ = -0.75f + (19.0f - subProcess) / 10.0f * 0.5f;
                        localItemY = -0.09375f + (19.0f - subProcess) / 10.0f * 0.21875f;
                    } else {
                        localItemZ = -1.0f + (oZ - (24.0f - subProcess) / 5.0f * oZ);
                        localItemY = -0.34375f + (24.0f - subProcess) / 5.0f * 0.25f;
                    }
                }
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)localItemX, (double)localItemY, (double)localItemZ);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), localAngle, true));
                matrixStack.func_227862_a_(scale, scale, 0.5f);
                ClientUtils.mc().func_175599_af().func_229110_a_(dList.get(d), ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
                matrixStack.func_227865_b_();
            }
        }
        double playerDistanceSq = ClientUtils.mc().field_71439_g.func_195048_a(Vector3d.func_237489_a_((Vector3i)blockPos));
        if (!blueprintStack.func_190926_b() && playerDistanceSq < 1000.0) {
            BlueprintLines blueprint;
            BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(blueprintStack, "blueprint"));
            BlueprintCraftingRecipe recipe = te.selectedRecipe < 0 || te.selectedRecipe >= recipes.length ? null : recipes[te.selectedRecipe];
            BlueprintLines blueprintLines = blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, te.getWorldNonnull());
            if (blueprint != null) {
                float lineWidth = playerDistanceSq < 6.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(-0.195, 0.125, 0.97);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -45.0f, true));
                float scale = 0.5f / (float)blueprint.textureScale;
                matrixStack.func_227862_a_(scale, -scale, scale);
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                blueprint.draw(lineWidth, matrixStack, bufferIn);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227865_b_();
    }

    public static void renderModelPart(MatrixStack matrix, BlockRendererDispatcher blockRenderer, IRenderTypeBuffer buffers, World world, BlockState state, IBakedModel model, BlockPos pos, String ... parts) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(-0.5, -0.5, -0.5);
        SinglePropertyModelData<IEProperties.IEObjState> data = new SinglePropertyModelData<IEProperties.IEObjState>(new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts)), IEProperties.Model.IE_OBJ_STATE);
        blockRenderer.func_175019_b().renderModel((IBlockDisplayReader)world, model, state, pos, matrix, buffers.getBuffer(RenderType.func_228639_c_()), false, world.field_73012_v, 0L, 0, data);
        matrix.func_227865_b_();
    }

    public static BlueprintLines getBlueprintDrawable(BlueprintCraftingRecipe recipe, World world) {
        if (recipe == null) {
            return null;
        }
        BlueprintLines blueprint = blueprintCache.get(recipe);
        if (blueprint == null) {
            blueprint = AutoWorkbenchRenderer.getBlueprintDrawable(recipe.output, world);
            blueprintCache.put(recipe, blueprint);
        }
        return blueprint;
    }

    public static BlueprintLines getBlueprintDrawable(ItemStack stack, World world) {
        if (stack.func_190926_b()) {
            return null;
        }
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            IBakedModel ibakedmodel = ClientUtils.mc().func_175599_af().func_184393_a(stack, world, (LivingEntity)player);
            HashSet<String> textures = new HashSet<String>();
            List quads = ibakedmodel.getQuads(null, null, world.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
            for (BakedQuad bakedQuad : quads) {
                if (bakedQuad == null || bakedQuad.func_187508_a() == null) continue;
                textures.add(bakedQuad.func_187508_a().func_195668_m().toString());
            }
            for (String string : textures) {
                ResourceLocation rl = new ResourceLocation(string);
                rl = new ResourceLocation(rl.func_110624_b(), String.format("%s/%s%s", "textures", rl.func_110623_a(), ".png"));
                IResource resource = ClientUtils.mc().func_195551_G().func_199002_a(rl);
                BufferedImage bufferedImage = ClientUtils.readBufferedImage(resource.func_199027_b());
                if (bufferedImage == null) continue;
                images.add(bufferedImage);
            }
        }
        catch (Exception ibakedmodel) {
            // empty catch block
        }
        if (images.isEmpty()) {
            return null;
        }
        ArrayList lines = new ArrayList();
        HashSet<TexturePoint> testSet = new HashSet<TexturePoint>();
        HashMultimap area = HashMultimap.create();
        int wMax = 0;
        for (BufferedImage bufferedImage : images) {
            HashSet<Pair> temp_lines = new HashSet<Pair>();
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            if (h > w) {
                h = w;
            }
            if (w > wMax) {
                wMax = w;
            }
            for (int hh = 0; hh < h; ++hh) {
                for (int ww = 0; ww < w; ++ww) {
                    int argb = bufferedImage.getRGB(ww, hh);
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    float intesity = (r + b + g) / 3.0f;
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    boolean added = false;
                    TexturePoint tp = new TexturePoint(ww, hh, w);
                    if (!testSet.contains(tp)) {
                        for (Integer key : area.keySet()) {
                            for (TexturePoint p : area.get((Object)key)) {
                                float dB;
                                float dG;
                                float mod = (float)w / (float)p.scale;
                                int pColour = bufferedImage.getRGB((int)((float)p.x * mod), (int)((float)p.y * mod));
                                float dR = r - (float)(pColour >> 16 & 0xFF) / 255.0f;
                                double delta = Math.sqrt(dR * dR + (dG = g - (float)(pColour >> 8 & 0xFF) / 255.0f) * dG + (dB = b - (float)(pColour & 0xFF) / 255.0f) * dB);
                                if (!(delta < 0.25)) continue;
                                area.put((Object)key, (Object)tp);
                                added = true;
                                break;
                            }
                            if (!added) continue;
                            break;
                        }
                        if (!added) {
                            area.put((Object)argb, (Object)tp);
                        }
                        testSet.add(tp);
                    }
                    for (int i = 0; i < 4; ++i) {
                        int xx;
                        int n = i == 0 ? -1 : (xx = i == 1 ? 1 : 0);
                        int yy = i == 2 ? -1 : (i == 3 ? 1 : 0);
                        int u = ww + xx;
                        int v = hh + yy;
                        int neighbour = 0;
                        float delta = 1.0f;
                        boolean notTransparent = false;
                        if (u >= 0 && u < w && v >= 0 && v < h) {
                            neighbour = bufferedImage.getRGB(u, v);
                            boolean bl = notTransparent = (neighbour >> 24 & 0xFF) > 0;
                            if (notTransparent) {
                                float bDelta;
                                float gDelta;
                                float rDelta;
                                float neighbourIntesity = (float)((neighbour >> 16 & 0xFF) + (neighbour >> 8 & 0xFF) + (neighbour & 0xFF)) / 765.0f;
                                float intesityDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(intesity - neighbourIntesity)));
                                delta = Math.max(intesityDelta, Math.max(rDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(r - (float)(neighbour >> 16 & 0xFF) / 255.0f))), Math.max(gDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(g - (float)(neighbour >> 8 & 0xFF) / 255.0f))), bDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(b - (float)(neighbour & 0xFF) / 255.0f))))));
                                float f = (double)delta < 0.25 ? 0.0f : (delta = (double)delta > 0.4 ? 1.0f : delta);
                            }
                        }
                        if (!(delta > 0.0f)) continue;
                        Pair l = Pair.of((Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 0)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 0)), w), (Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 1)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 1)), w));
                        temp_lines.add(l);
                    }
                }
            }
            lines.addAll(temp_lines);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(area.keySet());
        arrayList.sort(Comparator.comparingDouble(AutoWorkbenchRenderer::getLuminance));
        HashMultimap complete_areaMap = HashMultimap.create();
        int lineNumber = 2;
        int lineStyle = 0;
        for (Integer i : arrayList) {
            complete_areaMap.putAll((Object)new ShadeStyle(lineNumber, lineStyle), (Iterable)area.get((Object)i));
            ++lineStyle;
            if ((lineStyle %= 3) != 0) continue;
            ++lineNumber;
        }
        HashSet<Pair<Point, Point>> complete_lines = new HashSet<Pair<Point, Point>>();
        for (Pair line : lines) {
            TexturePoint p1 = (TexturePoint)line.getKey();
            TexturePoint p2 = (TexturePoint)line.getValue();
            complete_lines.add((Pair<Point, Point>)Pair.of((Object)new Point((int)((float)p1.x / (float)p1.scale * (float)wMax), (int)((float)p1.y / (float)p1.scale * (float)wMax)), (Object)new Point((int)((float)p2.x / (float)p2.scale * (float)wMax), (int)((float)p2.y / (float)p2.scale * (float)wMax))));
        }
        return new BlueprintLines(wMax, complete_lines, (HashMultimap<ShadeStyle, Point>)complete_areaMap);
    }

    private static double getLuminance(int rgb) {
        return Math.sqrt(0.241 * (double)(rgb >> 16 & 0xFF) + 0.691 * (double)(rgb >> 8 & 0xFF) + 0.068 * (double)(rgb & 0xFF));
    }

    static {
        blueprintCache = new HashMap();
    }

    public static class BlueprintLines {
        final int textureScale;
        final Set<Pair<Point, Point>> lines;
        final HashMultimap<ShadeStyle, Point> areas;

        BlueprintLines(int textureScale, Set<Pair<Point, Point>> lines, HashMultimap<ShadeStyle, Point> areas) {
            this.textureScale = textureScale;
            this.lines = lines;
            this.areas = areas;
        }

        public int getTextureScale() {
            return this.textureScale;
        }

        public void draw(float lineWidth, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
            IVertexBuilder baseBuilder = buffer.getBuffer(IERenderTypes.getLines(lineWidth));
            TransformingVertexBuilder builder = new TransformingVertexBuilder(baseBuilder, matrixStack);
            builder.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            for (Pair<Point, Point> line : this.lines) {
                builder.func_225582_a_(((Point)line.getKey()).x, ((Point)line.getKey()).y, 0.0).func_181675_d();
                builder.func_225582_a_(((Point)line.getValue()).x, ((Point)line.getValue()).y, 0.0).func_181675_d();
            }
            if (lineWidth >= 1.0f) {
                for (ShadeStyle style : this.areas.keySet()) {
                    for (Point pixel : this.areas.get((Object)style)) {
                        style.drawShading(pixel, builder);
                    }
                }
            }
        }
    }

    private static class TexturePoint
    extends Point {
        final int scale;

        public TexturePoint(int x, int y, int scale) {
            super(x, y);
            this.scale = scale;
        }

        @Override
        public int hashCode() {
            return 31 * (31 * this.x + this.y) + this.scale;
        }
    }

    private static class ShadeStyle {
        int stripeAmount = 1;
        int stripeDirection = 0;

        ShadeStyle(int stripeAmount, int stripeDirection) {
            this.stripeAmount = stripeAmount;
            this.stripeDirection = stripeDirection;
        }

        void drawShading(Point pixel, IVertexBuilder builder) {
            float step = 1.0f / (float)this.stripeAmount;
            float offset = step / 2.0f;
            if (this.stripeDirection > 1) {
                int perSide = this.stripeAmount / 2 + (this.stripeAmount % 2 == 1 ? 1 : 0);
                step = 1.0f / (float)perSide;
                offset = this.stripeAmount % 2 == 1 ? step : step / 2.0f;
            }
            for (int i = 0; i < this.stripeAmount; ++i) {
                if (this.stripeDirection == 0) {
                    builder.func_225582_a_((double)((float)pixel.x + offset + step * (float)i), (double)pixel.y, 0.0).func_181675_d();
                    builder.func_225582_a_((double)((float)pixel.x + offset + step * (float)i), (double)(pixel.y + 1), 0.0).func_181675_d();
                    continue;
                }
                if (this.stripeDirection == 1) {
                    builder.func_225582_a_((double)pixel.x, (double)((float)pixel.y + offset + step * (float)i), 0.0).func_181675_d();
                    builder.func_225582_a_((double)(pixel.x + 1), (double)((float)pixel.y + offset + step * (float)i), 0.0).func_181675_d();
                    continue;
                }
                if (this.stripeDirection != 2) continue;
                if (i == this.stripeAmount - 1 && this.stripeAmount % 2 == 1) {
                    builder.func_225582_a_((double)pixel.x, (double)(pixel.y + 1), 0.0).func_181675_d();
                    builder.func_225582_a_((double)(pixel.x + 1), (double)pixel.y, 0.0).func_181675_d();
                    continue;
                }
                if (i % 2 == 0) {
                    builder.func_225582_a_((double)pixel.x, (double)((float)pixel.y + offset + step * (float)(i / 2)), 0.0).func_181675_d();
                    builder.func_225582_a_((double)((float)pixel.x + offset + step * (float)(i / 2)), (double)pixel.y, 0.0).func_181675_d();
                    continue;
                }
                builder.func_225582_a_((double)((float)(pixel.x + 1) - offset - step * (float)(i / 2)), (double)(pixel.y + 1), 0.0).func_181675_d();
                builder.func_225582_a_((double)(pixel.x + 1), (double)((float)(pixel.y + 1) - offset - step * (float)(i / 2)), 0.0).func_181675_d();
            }
        }
    }
}

