/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SiloTileEntity
extends MultiblockPartTileEntity<SiloTileEntity>
implements IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockBounds {
    public ItemStack identStack = ItemStack.field_190927_a;
    public int storageAmount = 0;
    private static final int MAX_STORAGE = 41472;
    boolean lockItem = false;
    private final LayeredComparatorOutput comparatorHelper = new LayeredComparatorOutput(41472.0, 6, () -> this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c()), layer -> {
        BlockPos masterPos = this.field_174879_c.func_177973_b((Vector3i)this.offsetToMaster);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos = masterPos.func_177982_a(x, layer + 1, z);
                this.field_145850_b.func_195593_d(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
            }
        }
    });
    private final List<CapabilityReference<IItemHandler>> outputCaps = new ArrayList<CapabilityReference<IItemHandler>>();
    private static final CachedShapesWithTransform<BlockPos, Direction> BLOCK_BOUNDS = CachedShapesWithTransform.createDirectional(pos -> {
        if (pos.func_177958_n() % 2 == 0 && pos.func_177956_o() == 0 && pos.func_177952_p() % 2 == 0) {
            float xMin = pos.func_177958_n() == 2 ? 0.75f : 0.0f;
            float xMax = pos.func_177958_n() == 0 ? 0.25f : 1.0f;
            float zMin = pos.func_177952_p() == 2 ? 0.75f : 0.0f;
            float zMax = pos.func_177952_p() == 0 ? 0.25f : 1.0f;
            return ImmutableList.of((Object)new AxisAlignedBB((double)xMin, 0.0, (double)zMin, (double)xMax, 1.0, (double)zMax));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    });
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    private final LazyOptional<IItemHandler> insertionHandler;
    private static final BlockPos bottomIoOffset = new BlockPos(1, 0, 1);
    private static final BlockPos topIoOffset = new BlockPos(1, 6, 1);
    private static final Set<BlockPos> ioOffsets = ImmutableSet.of((Object)bottomIoOffset, (Object)topIoOffset);

    public SiloTileEntity() {
        super(IEMultiblocks.SILO, (TileEntityType)IETileTypes.SILO.get(), true);
        for (Direction f : DirectionUtils.VALUES) {
            if (f == Direction.UP) continue;
            this.outputCaps.add(CapabilityReference.forNeighbor((TileEntity)this, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f));
        }
        this.insertionHandler = this.registerConstantCap(new SiloInventoryHandler(this));
        this.redstoneControlInverted = true;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.isDummy() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.identStack.func_190926_b() && this.storageAmount > 0 && this.field_145850_b.func_82737_E() % 8L == 0L && !this.isRSDisabled()) {
            for (CapabilityReference<IItemHandler> output : this.outputCaps) {
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.identStack, (int)1);
                if (!(stack = Utils.insertStackIntoInventory(output, stack, false)).func_190926_b()) continue;
                --this.storageAmount;
                if (this.storageAmount <= 0) {
                    this.identStack = ItemStack.field_190927_a;
                }
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                if (this.storageAmount > 0) continue;
                break;
            }
        }
        this.comparatorHelper.update(this.storageAmount);
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_150297_b("identStack", 10)) {
            CompoundNBT t = nbt.func_74775_l("identStack");
            this.identStack = ItemStack.func_199557_a((CompoundNBT)t);
        } else {
            this.identStack = ItemStack.field_190927_a;
        }
        this.storageAmount = nbt.func_74762_e("storageAmount");
        this.lockItem = nbt.func_74767_n("lockItem");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.identStack.func_190926_b()) {
            CompoundNBT t = this.identStack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a("identStack", (INBT)t);
        }
        nbt.func_74768_a("storageAmount", this.storageAmount);
        nbt.func_74757_a("lockItem", this.lockItem);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return BLOCK_BOUNDS.get(this.posInMultiblock, this.getFacing());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offsetToMaster.equals((Object)BlockPos.field_177992_a) ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 7, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ioOffsets.contains(this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getComparatorInputOverride() {
        if (bottomIoOffset.equals((Object)this.posInMultiblock)) {
            return this.comparatorHelper.getCurrentMasterOutput();
        }
        SiloTileEntity master = (SiloTileEntity)this.master();
        if (this.offsetToMaster.func_177956_o() >= 1 && master != null) {
            return this.comparatorHelper.getLayerOutput(this.offsetToMaster.func_177956_o() - 1);
        }
        return 0;
    }

    public static class SiloInventoryHandler
    implements IItemHandler {
        SiloTileEntity silo;

        public SiloInventoryHandler(SiloTileEntity silo) {
            this.silo = silo;
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.field_190927_a;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.silo.identStack, (int)this.silo.storageAmount);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.func_77946_l();
            SiloTileEntity silo = (SiloTileEntity)this.silo.master();
            int space = 41472 - silo.storageAmount;
            if (slot != 0 || space < 1 || stack.func_190926_b() || !silo.identStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)silo.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.func_190916_E());
            if (!simulate) {
                silo.storageAmount += accepted;
                if (silo.identStack.func_190926_b()) {
                    silo.identStack = stack.func_77946_l();
                }
                silo.func_70296_d();
                silo.markContainingBlockForUpdate(null);
            }
            stack.func_190918_g(accepted);
            if (stack.func_190916_E() < 1) {
                stack = ItemStack.field_190927_a;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            SiloTileEntity silo = (SiloTileEntity)this.silo.master();
            if (slot != 1 || silo.storageAmount < 1 || amount < 1 || silo.identStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int returned = Math.min(Math.min(silo.storageAmount, amount), silo.identStack.func_77976_d());
            ItemStack out = ItemHandlerHelper.copyStackWithSize((ItemStack)silo.identStack, (int)returned);
            if (!simulate) {
                silo.storageAmount -= out.func_190916_E();
                if (silo.storageAmount <= 0 && !silo.lockItem) {
                    silo.identStack = ItemStack.field_190927_a;
                }
                silo.func_70296_d();
                silo.func_145836_u();
                silo.markContainingBlockForUpdate(null);
            }
            return out;
        }

        public int getSlotLimit(int slot) {
            return 41472;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.silo.identStack);
        }
    }
}

