/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class LogicUnitTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IIEInventory,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IStateBasedDirectional,
LogicCircuitHandler.ILogicCircuitHandler,
IEBlockInterfaces.IHasObjProperty {
    private static final int SIZE_COLORS = DyeColor.values().length;
    private static final int SIZE_REGISTERS = LogicCircuitHandler.LogicCircuitRegister.values().length - SIZE_COLORS;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private final Map<Direction, boolean[]> inputs = new EnumMap<Direction, boolean[]>(Direction.class);
    private final boolean[] registers = new boolean[SIZE_REGISTERS];
    private final boolean[] outputs = new boolean[SIZE_COLORS];
    private final Map<Direction, LazyOptional<CapabilityRedstoneNetwork.RedstoneBundleConnection>> redstoneCaps = new EnumMap<Direction, LazyOptional<CapabilityRedstoneNetwork.RedstoneBundleConnection>>(Direction.class);
    ResettableLazy<boolean[]> combinedInputs;
    private final Map<String, IEProperties.VisibilityList> visibilityListMap;
    private static IEProperties.VisibilityList visibilityTransparent = IEProperties.VisibilityList.show("tubes");

    public LogicUnitTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.LOGIC_UNIT.get()));
        for (Direction f : DirectionUtils.VALUES) {
            LazyOptional<1> forSide = this.registerConstantCap(new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

                @Override
                public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler, Direction side) {
                    byte[] foreignInputs = handler.getValuesExcluding(cp);
                    boolean[] sideInputs = LogicUnitTileEntity.this.inputs.getOrDefault(side, new boolean[SIZE_COLORS]);
                    boolean[] preInput = Arrays.copyOf(sideInputs, SIZE_COLORS);
                    for (int i = 0; i < SIZE_COLORS; ++i) {
                        sideInputs[i] = foreignInputs[i] > 0;
                    }
                    if (!Arrays.equals(preInput, sideInputs)) {
                        LogicUnitTileEntity.this.inputs.put(side, sideInputs);
                        LogicUnitTileEntity.this.combinedInputs.reset();
                        LogicUnitTileEntity.this.updateOutputs();
                    }
                }

                @Override
                public void updateInput(byte[] signals, ConnectionPoint cp, Direction side) {
                    for (DyeColor dye : DyeColor.values()) {
                        if (!LogicUnitTileEntity.this.outputs[dye.func_196059_a()]) continue;
                        signals[dye.func_196059_a()] = 15;
                    }
                }
            });
            this.redstoneCaps.put(f, forSide);
        }
        this.combinedInputs = new ResettableLazy(() -> {
            boolean[] ret = new boolean[SIZE_COLORS];
            for (boolean[] side : this.inputs.values()) {
                for (int i = 0; i < SIZE_COLORS; ++i) {
                    int n = i;
                    ret[n] = ret[n] | side[i];
                }
            }
            return ret;
        });
        this.visibilityListMap = new ConcurrentHashMap<String, IEProperties.VisibilityList>();
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.func_225608_bj_();
    }

    public void func_73660_a() {
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c(), 1);
        CompoundNBT nbt = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        if (!nbt.isEmpty()) {
            stack.func_77982_d(nbt);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_196082_o(), false);
        }
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof LogicCircuitBoardItem;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.updateOutputs();
        this.markContainingBlockForUpdate(null);
    }

    private void updateOutputs() {
        boolean[] outPre = Arrays.copyOf(this.outputs, SIZE_COLORS);
        Arrays.fill(this.registers, false);
        Arrays.fill(this.outputs, false);
        this.inventory.stream().map(LogicCircuitBoardItem::getInstruction).filter(Objects::nonNull).forEachOrdered(instruction -> instruction.apply(this));
        if (!Arrays.equals(outPre, this.outputs)) {
            this.markConnectorsDirty();
        }
    }

    private void markConnectorsDirty() {
        this.redstoneCaps.values().forEach(cap -> cap.ifPresent(CapabilityRedstoneNetwork.RedstoneBundleConnection::markDirty));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION && facing != null) {
            return this.redstoneCaps.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean getLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register) {
        if (register.ordinal() < SIZE_COLORS) {
            return this.combinedInputs.get()[register.ordinal()];
        }
        return this.registers[register.ordinal() - SIZE_COLORS];
    }

    @Override
    public void setLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register, boolean state) {
        if (register.ordinal() < SIZE_COLORS) {
            this.outputs[register.ordinal()] = state;
        } else {
            this.registers[register.ordinal() - LogicUnitTileEntity.SIZE_COLORS] = state;
        }
    }

    private String getVisibilityKey() {
        return this.inventory.stream().map(itemStack -> !itemStack.func_190926_b() ? "1" : "0").collect(Collectors.joining());
    }

    @Override
    public IEProperties.VisibilityList compileDisplayList(BlockState state) {
        if (MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_()) {
            return visibilityTransparent;
        }
        return this.visibilityListMap.computeIfAbsent(this.getVisibilityKey(), key -> {
            ArrayList parts = Lists.newArrayList((Object[])new String[]{"base"});
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) != '1') continue;
                parts.add("board_" + i);
            }
            return IEProperties.VisibilityList.show(parts);
        });
    }
}

