/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.MopedEntity;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Calendar;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class RenderMoped
extends AbstractRenderVehicle<MopedEntity> {
    private static final ResourceLocation TEXTURE_CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("textures/entity/chest/normal.png");
    private final ModelRenderer lid;
    private final ModelRenderer base;
    private final ModelRenderer lock;
    public final boolean isChristmas;

    public RenderMoped() {
        Calendar calendar = Calendar.getInstance();
        this.isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        this.base = new ModelRenderer(64, 64, 0, 19);
        this.base.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.lock = new ModelRenderer(64, 64, 0, 0);
        this.lock.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.lock.field_78797_d = 8.0f;
    }

    @Override
    public void render(MopedEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_BODY.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.0625, 0.71875);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-22.5f));
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(turnRotation / 2.0f));
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(22.5f));
        matrixStack.func_227861_a_(0.0, 0.0, -0.71875);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.835, 0.525);
        matrixStack.func_227862_a_(0.8f, 0.8f, 0.8f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_HANDLES.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.12, 0.785);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-22.5f));
        matrixStack.func_227862_a_(0.9f, 0.9f, 0.9f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_MUD_GUARD.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
        if (entity.hasWheels()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.4, 0.90625);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-frontWheelSpin));
            }
            matrixStack.func_227862_a_(1.3f, 1.3f, 1.3f);
            RenderUtil.renderColoredModel(RenderUtil.getModel(new ItemStack((IItemProvider)ModItems.STANDARD_WHEEL.get())), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        if (entity.hasChest()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.25, -0.65);
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(180.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            ItemStack chest = new ItemStack((IItemProvider)Blocks.field_150486_ae);
            RenderUtil.renderModel(chest, ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_, RenderUtil.getModel(chest));
            matrixStack.func_227865_b_();
        }
    }

    @Override
    public void applyPlayerModel(MopedEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 6.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-75.0f - turnRotation);
        model.field_178723_h.field_78796_g = (float)Math.toRadians(7.0);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-75.0f + turnRotation);
        model.field_178724_i.field_78796_g = (float)Math.toRadians(-7.0);
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-55.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-55.0);
    }

    @Override
    public void applyPlayerRender(MopedEntity entity, PlayerEntity player, float partialTicks, MatrixStack matrixStack, IVertexBuilder builder) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vector3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_216372_d(-1.0, 1.0, 1.0).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = -seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            matrixStack.func_227861_a_(offsetX, offsetY, offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / 45.0f;
            matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(turnAngleNormal * currentSpeedNormal * 20.0f));
            matrixStack.func_227861_a_(-offsetX, -offsetY, -offsetZ);
        }
    }

    private void renderChest(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer lid, ModelRenderer lock, ModelRenderer base, float p_228871_6_, int lightTexture, int overlayTexture) {
        lock.field_78795_f = lid.field_78795_f = -(p_228871_6_ * 1.5707964f);
        lid.func_228308_a_(matrixStack, vertexBuilder, lightTexture, overlayTexture);
        lock.func_228308_a_(matrixStack, vertexBuilder, lightTexture, overlayTexture);
        base.func_228308_a_(matrixStack, vertexBuilder, lightTexture, overlayTexture);
    }
}

